/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.neo4j.jdbc.BookmarkManager;
import org.neo4j.jdbc.ConnectionImpl;
import org.neo4j.jdbc.Neo4jDriver;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jTransaction;
import org.neo4j.jdbc.NoopBookmarkManagerImpl;
import org.neo4j.jdbc.authn.spi.Authentication;
import org.neo4j.jdbc.internal.bolt.BoltAdapters;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.AuthInfo;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.BasicResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.TransactionType;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltFailureException;
import org.neo4j.jdbc.internal.shaded.bolt.message.Message;
import org.neo4j.jdbc.internal.shaded.bolt.message.Messages;
import org.neo4j.jdbc.internal.shaded.bolt.summary.CommitSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.PullSummary;
import org.neo4j.jdbc.values.Record;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

final class DefaultTransactionImpl
implements Neo4jTransaction {
    private final BoltConnection boltConnection;
    private final FatalExceptionHandler fatalExceptionHandler;
    private final CompletionStage<Void> beginPipelinedStage;
    private final boolean autoCommit;
    private final BookmarkManager bookmarkManager;
    private final Consumer<Neo4jTransaction.State> onFailedCallback;
    private final Set<String> usedBookmarks;
    private final List<Neo4jTransaction.RunResponse> openResults = new ArrayList<Neo4jTransaction.RunResponse>();
    private Neo4jTransaction.State state;
    private SQLException exception;

    DefaultTransactionImpl(BoltConnection boltConnection, BookmarkManager bookmarkManager, Map<String, Object> transactionMetadata, FatalExceptionHandler fatalExceptionHandler, boolean resetNeeded, boolean autoCommit, AccessMode accessMode, Neo4jTransaction.State state, String databaseName, Consumer<Neo4jTransaction.State> onFailedCallback, Authentication currentAuthentication) {
        this.boltConnection = Objects.requireNonNull(boltConnection);
        this.fatalExceptionHandler = Objects.requireNonNull(fatalExceptionHandler);
        this.bookmarkManager = Objects.requireNonNullElseGet(bookmarkManager, NoopBookmarkManagerImpl::new);
        this.onFailedCallback = onFailedCallback;
        this.usedBookmarks = this.bookmarkManager.getBookmarks(Function.identity());
        this.autoCommit = autoCommit;
        this.state = Objects.requireNonNullElse(state, Neo4jTransaction.State.NEW);
        this.beginPipelinedStage = this.boltConnection.authInfo().thenApply(AuthInfo::authToken).thenCompose(previousAuthToken -> {
            TransactionType txType = this.autoCommit ? TransactionType.UNCONSTRAINED : TransactionType.DEFAULT;
            ArrayList<Message> messages = new ArrayList<Message>(4);
            if (resetNeeded) {
                messages.add(Messages.reset());
            }
            AuthToken currentAuthToken = Neo4jDriver.toAuthToken(currentAuthentication);
            if (!previousAuthToken.asMap().equals(currentAuthToken.asMap())) {
                ConnectionImpl.LOGGER.log(Level.FINE, () -> "Authentication has changed, pipelining logoff and logon messages");
                messages.add(Messages.logoff());
                messages.add(Messages.logon(Neo4jDriver.toAuthToken(currentAuthentication)));
            }
            messages.add(Messages.beginTransaction(databaseName, accessMode, null, this.usedBookmarks, txType, null, BoltAdapters.adaptMap(transactionMetadata), NotificationConfig.defaultConfig()));
            return this.boltConnection.write(messages);
        });
    }

    @Override
    public Neo4jTransaction.RunAndPullResponses runAndPull(String query, Map<String, Object> parameters, int fetchSize, int timeout) throws SQLException {
        this.assertNoException();
        this.assertRunnableState();
        BasicResponseHandler handler = new BasicResponseHandler();
        CompletableFuture<Neo4jTransaction.RunAndPullResponses> responsesFuture = this.beginPipelinedStage.thenCompose(ignored -> {
            List<Message> messages = List.of(Messages.run(query, BoltAdapters.adaptMap(parameters)), Messages.pull(-1L, fetchSize));
            return this.boltConnection.writeAndFlush((ResponseHandler)handler, messages);
        }).thenCompose(ignored -> handler.summaries()).thenApply(DefaultTransactionImpl::asRunAndPullResponses).toCompletableFuture();
        Neo4jTransaction.RunAndPullResponses responses = this.execute(responsesFuture, timeout);
        if (responses.pullResponse().hasMore()) {
            this.openResults.add(responses.runResponse());
        }
        this.state = Neo4jTransaction.State.READY;
        return responses;
    }

    @Override
    public Neo4jTransaction.DiscardResponse runAndDiscard(String query, Map<String, Object> parameters, int timeout, boolean commit) throws SQLException {
        this.assertNoException();
        this.assertRunnableState();
        BasicResponseHandler handler = new BasicResponseHandler();
        CompletableFuture<Neo4jTransaction.DiscardResponse> responsesFuture = this.beginPipelinedStage.thenCompose(ignored -> {
            ArrayList<Message> messages = new ArrayList<Message>(3);
            messages.add(Messages.run(query, BoltAdapters.adaptMap(parameters)));
            messages.add(Messages.discard(-1L, -1L));
            if (commit) {
                messages.add(Messages.commit());
            }
            return this.boltConnection.writeAndFlush((ResponseHandler)handler, messages);
        }).thenCompose(ignored -> handler.summaries()).thenApply(DefaultTransactionImpl::asDiscardResponse).toCompletableFuture();
        Neo4jTransaction.DiscardResponse response = this.execute(responsesFuture, timeout);
        if (!Neo4jTransaction.State.COMMITTED.equals((Object)this.state)) {
            this.state = commit ? Neo4jTransaction.State.COMMITTED : Neo4jTransaction.State.READY;
        }
        return response;
    }

    @Override
    public Neo4jTransaction.PullResponse pull(Neo4jTransaction.RunResponse runResponse, long request) throws SQLException {
        this.assertNoException();
        if (!Neo4jTransaction.State.READY.equals((Object)this.state)) {
            throw new Neo4jException(Neo4jException.withReason(String.format("The requested action is not supported in %s transaction state", new Object[]{this.state})));
        }
        BasicResponseHandler handler = new BasicResponseHandler();
        CompletableFuture<Neo4jTransaction.PullResponse> responseFuture = this.boltConnection.writeAndFlush((ResponseHandler)handler, Messages.pull(runResponse.queryId(), request)).thenCompose(ignored -> handler.summaries()).thenApply(summaries -> DefaultTransactionImpl.asPullResponse(runResponse.keys(), summaries.valuesList(), summaries.pullSummary())).toCompletableFuture();
        Neo4jTransaction.PullResponse pullResponse = this.execute(responseFuture, 0);
        if (!pullResponse.hasMore()) {
            this.openResults.remove(runResponse);
        }
        return pullResponse;
    }

    @Override
    public void commit() throws SQLException {
        this.assertNoException();
        this.assertRunnableState();
        BasicResponseHandler handler = new BasicResponseHandler();
        ArrayList<Message> messages = new ArrayList<Message>(this.openResults.size() + 1);
        this.appendDiscards(messages);
        messages.add(Messages.commit());
        CompletableFuture<CommitSummary> responsesFuture = this.beginPipelinedStage.thenCompose(ignored -> this.boltConnection.writeAndFlush((ResponseHandler)handler, messages)).thenCompose(ignored -> handler.summaries()).thenApply(BasicResponseHandler.Summaries::commitSummary).whenComplete((response, error) -> {
            if (response != null && !response.bookmark().orElse("").isBlank()) {
                this.bookmarkManager.updateBookmarks(Function.identity(), this.usedBookmarks, List.of(response.bookmark().orElse("")));
            }
            if (error == null) {
                this.state = Neo4jTransaction.State.COMMITTED;
            }
        }).toCompletableFuture();
        this.execute(responsesFuture, 0);
        this.openResults.clear();
    }

    @Override
    public void rollback() throws SQLException {
        if (Neo4jTransaction.State.OPEN_FAILED.equals((Object)this.state)) {
            this.state = Neo4jTransaction.State.FAILED;
            return;
        }
        this.assertNoException();
        this.assertRunnableState();
        BasicResponseHandler handler = new BasicResponseHandler();
        ArrayList<Message> messages = new ArrayList<Message>(this.openResults.size() + 1);
        this.appendDiscards(messages);
        messages.add(Messages.rollback());
        CompletableFuture responsesFuture = this.beginPipelinedStage.thenCompose(ignored -> this.boltConnection.writeAndFlush((ResponseHandler)handler, messages)).thenCompose(ignored -> handler.summaries()).toCompletableFuture();
        this.execute(responsesFuture, 0);
        this.state = Neo4jTransaction.State.ROLLEDBACK;
        this.openResults.clear();
    }

    @Override
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public Neo4jTransaction.State getState() {
        return this.state;
    }

    @Override
    public void fail(SQLException exception) throws SQLException {
        this.assertRunnableState();
        this.exception = exception;
        this.state = this.autoCommit ? Neo4jTransaction.State.FAILED : Neo4jTransaction.State.OPEN_FAILED;
        this.onFailedCallback.accept(this.state);
    }

    private <T> T execute(CompletableFuture<T> future, int timeout) throws SQLException {
        try {
            return timeout > 0 ? future.get(timeout, TimeUnit.SECONDS) : future.get();
        }
        catch (TimeoutException ignored) {
            this.fail(new Neo4jException(Neo4jException.GQLError.$25N02.withMessage("The transaction is no longer valid")));
            throw new SQLTimeoutException("The query timeout has been exceeded");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.fail(new Neo4jException(Neo4jException.GQLError.$25N02.withMessage("The transaction is no longer valid")));
            throw new Neo4jException(Neo4jException.withInternal(ex, "The thread has been interrupted."));
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            Neo4jException sqlException = new Neo4jException(Neo4jException.withMessageAndCause("An error occurred while handling request", cause));
            if (cause instanceof BoltFailureException) {
                this.fail(new Neo4jException(Neo4jException.GQLError.$25N02.withMessage("The transaction is no longer valid")));
            } else {
                this.fail(new Neo4jException(Neo4jException.GQLError.$08000.withMessage("The connection is no longer valid")));
                this.fatalExceptionHandler.handle(this.exception, sqlException);
            }
            throw sqlException;
        }
    }

    private void appendDiscards(List<Message> messages) {
        for (Neo4jTransaction.RunResponse runResponse : this.openResults) {
            messages.add(Messages.discard(runResponse.queryId(), -1L));
        }
    }

    private void assertNoException() throws SQLException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void assertRunnableState() throws SQLException {
        if (!this.isRunnable()) {
            throw new Neo4jException(Neo4jException.withReason(String.format("The requested action is not supported in %s transaction state", new Object[]{this.state})));
        }
    }

    private static Neo4jTransaction.RunAndPullResponses asRunAndPullResponses(BasicResponseHandler.Summaries summaries) {
        return new Neo4jTransaction.RunAndPullResponses(DefaultTransactionImpl.asRunResponse(summaries), DefaultTransactionImpl.asPullResponse(summaries.runSummary().keys(), summaries.valuesList(), summaries.pullSummary()));
    }

    private static Neo4jTransaction.RunResponse asRunResponse(BasicResponseHandler.Summaries summaries) {
        return new RunResponseImpl(summaries.runSummary().queryId(), summaries.runSummary().keys());
    }

    private static Neo4jTransaction.PullResponse asPullResponse(List<String> keys, List<List<org.neo4j.jdbc.internal.shaded.bolt.values.Value>> valuesList, PullSummary pullSummary) {
        return new PullResponseImpl(pullSummary.hasMore(), valuesList.stream().map(v -> DefaultTransactionImpl.asRecord(keys, v)).toList(), DefaultTransactionImpl.asResultSummary(pullSummary.metadata()));
    }

    private static Record asRecord(List<String> keys, List<org.neo4j.jdbc.internal.shaded.bolt.values.Value> values) {
        return Record.of(keys, (Value[])values.stream().map(Values::value).toArray(Value[]::new));
    }

    private static Neo4jTransaction.ResultSummary asResultSummary(Map<String, org.neo4j.jdbc.internal.shaded.bolt.values.Value> metadata) {
        return new Neo4jTransaction.ResultSummary(BoltAdapters.newSummaryCounters(metadata.get("stats")));
    }

    private static Neo4jTransaction.DiscardResponse asDiscardResponse(BasicResponseHandler.Summaries summaries) {
        return new DiscardResponseImpl(DefaultTransactionImpl.asResultSummary(summaries.discardSummary().metadata()));
    }

    @FunctionalInterface
    static interface FatalExceptionHandler {
        public void handle(SQLException var1, SQLException var2);
    }

    private record RunResponseImpl(long queryId, List<String> keys) implements Neo4jTransaction.RunResponse
    {
    }

    private record PullResponseImpl(boolean hasMore, List<Record> records, Neo4jTransaction.ResultSummary summary) implements Neo4jTransaction.PullResponse
    {
        @Override
        public Optional<Neo4jTransaction.ResultSummary> resultSummary() {
            return Optional.ofNullable(this.summary);
        }
    }

    record DiscardResponseImpl(Neo4jTransaction.ResultSummary summary) implements Neo4jTransaction.DiscardResponse
    {
        @Override
        public Optional<Neo4jTransaction.ResultSummary> resultSummary() {
            return Optional.ofNullable(this.summary);
        }
    }
}

