/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.neo4j.jdbc.AuthenticationManager;
import org.neo4j.jdbc.authn.spi.Authentication;
import org.neo4j.jdbc.authn.spi.ExpiringAuthentication;
import org.neo4j.jdbc.events.ConnectionListener;

final class DefaultAuthenticationManagerImpl
implements AuthenticationManager {
    private final URI targetUrl;
    private final Supplier<Authentication> authenticationSupplier;
    private final AtomicReference<AuthenticationAndState> currentAuthentication = new AtomicReference();
    private final Clock clock;
    private final Duration refreshOffset;
    private final List<ConnectionListener> listeners;

    DefaultAuthenticationManagerImpl(URI targetUrl, Supplier<Authentication> authenticationSupplier, Clock clock, Duration refreshOffset) {
        this.targetUrl = targetUrl;
        this.authenticationSupplier = authenticationSupplier;
        this.clock = clock;
        this.refreshOffset = refreshOffset;
        this.listeners = new ArrayList<ConnectionListener>();
    }

    boolean isValid(Authentication authentication) {
        if (authentication == null) {
            return false;
        }
        if (authentication instanceof ExpiringAuthentication) {
            ExpiringAuthentication expiringAuthentication = (ExpiringAuthentication)authentication;
            Instant expiresAt = expiringAuthentication.expiresAt();
            return expiresAt == null || expiresAt.minus(this.refreshOffset).isAfter(Instant.now(this.clock));
        }
        return true;
    }

    @Override
    public Authentication getOrRefresh() {
        AuthenticationAndState hlp = this.currentAuthentication.updateAndGet(previous -> {
            if (previous != null && this.isValid(previous.authentication)) {
                return new AuthenticationAndState(previous.authentication, State.REUSED);
            }
            Authentication authentication = this.authenticationSupplier.get();
            return new AuthenticationAndState(authentication, previous != null ? State.REFRESHED : State.NEW);
        });
        ConnectionListener.NewAuthenticationEvent.State eventState = hlp.state.toEventState();
        if (eventState != null) {
            this.notifyListeners(new ConnectionListener.NewAuthenticationEvent(this.targetUrl, eventState));
        }
        return hlp.authentication();
    }

    void notifyListeners(ConnectionListener.NewAuthenticationEvent event) {
        this.listeners.forEach(listener -> listener.onNewAuthentication(event));
    }

    @Override
    public void addListener(ConnectionListener connectionListener) {
        this.listeners.add(Objects.requireNonNull(connectionListener));
    }

    record AuthenticationAndState(Authentication authentication, State state) {
    }

    static enum State {
        NEW,
        REUSED,
        REFRESHED;


        ConnectionListener.NewAuthenticationEvent.State toEventState() {
            return switch (this) {
                case NEW -> ConnectionListener.NewAuthenticationEvent.State.NEW;
                case REFRESHED -> ConnectionListener.NewAuthenticationEvent.State.REFRESHED;
                default -> null;
            };
        }
    }
}

