/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import org.neo4j.jdbc.Lazy;
import org.neo4j.jdbc.LocalStatementImpl;
import org.neo4j.jdbc.Neo4jConversions;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jTransaction;
import org.neo4j.jdbc.values.Record;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

class ArrayImpl
implements java.sql.Array {
    private static final List<String> RESULT_SET_COLUMNS = List.of("index", "value");
    private final AtomicBoolean freed = new AtomicBoolean(false);
    private final Connection connection;
    private final Type arrayType;
    private final List<Value> values;
    private final Lazy<Object> array;

    static java.sql.Array of(Connection connection, String typeName, Object[] elements) throws SQLException {
        if (typeName == null || typeName.isBlank()) {
            throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid argument, typename is required"));
        }
        try {
            Type type = Type.valueOf(typeName);
            ArrayList<Value> allValues = new ArrayList<Value>();
            if (type == Type.BYTES) {
                byte[] bytes = new byte[elements.length];
                for (int i = 0; i < elements.length; ++i) {
                    Object element = elements[i];
                    bytes[i] = (Byte)element;
                }
                allValues.add(Values.value(bytes));
            } else if (elements != null) {
                for (Object element : elements) {
                    allValues.add(Values.value(element));
                }
            }
            ArrayImpl theArray = (ArrayImpl)ArrayImpl.of(connection, Values.value(allValues));
            if (type != Optional.ofNullable(theArray).map(a -> a.arrayType).orElse(Type.NULL)) {
                throw new Neo4jException(Neo4jException.GQLError.$22000.withMessage("Cannot satisfy type %s with the elements provided".formatted(typeName)));
            }
            return theArray;
        }
        catch (IllegalArgumentException ex) {
            throw new Neo4jException(Neo4jException.GQLError.$22000.withMessage("Invalid type name %s".formatted(typeName)));
        }
    }

    static java.sql.Array of(Connection connection, Value value) throws SQLException {
        boolean containsNulls;
        Type arrayType;
        if (value == null || value.hasType(Type.NULL)) {
            return null;
        }
        if (value.hasType(Type.BYTES)) {
            return new ArrayImpl(connection, Type.BYTES, List.of(value), false);
        }
        if (!value.hasType(Type.LIST)) {
            throw new Neo4jException(Neo4jException.GQLError.$22N01.withTemplatedMessage(new Object[]{value, "LIST", value.type()}));
        }
        List<Value> values = value.asList(Function.identity());
        if (value.isEmpty()) {
            arrayType = Type.ANY;
            containsNulls = false;
        } else {
            arrayType = values.stream().map(Value::type).filter(v -> v != Type.NULL).findFirst().orElse(Type.NULL);
            if (values.stream().anyMatch(v -> !v.hasType(arrayType) && !v.hasType(Type.NULL))) {
                throw new Neo4jException(Neo4jException.GQLError.$22G03.withTemplatedMessage(new Object[0]));
            }
            containsNulls = values.stream().anyMatch(v -> v.hasType(Type.NULL));
        }
        return new ArrayImpl(connection, arrayType, values, containsNulls);
    }

    ArrayImpl(Connection connection, Type arrayType, List<Value> values, boolean containsNulls) {
        this.connection = connection;
        this.arrayType = arrayType;
        this.values = values;
        this.array = Lazy.of(() -> {
            if (containsNulls) {
                return this.values.stream().map(Value::asObject).toArray(Object[]::new);
            }
            if (Type.BOOLEAN == this.arrayType) {
                boolean[] result = new boolean[this.values.size()];
                for (int i = 0; i < this.values.size(); ++i) {
                    result[i] = this.values.get(i).asBoolean();
                }
                return result;
            }
            if (Type.BYTES == this.arrayType) {
                return this.values.get(0).asByteArray();
            }
            if (Type.INTEGER == this.arrayType) {
                LongStream.Builder builder = LongStream.builder();
                this.values.forEach(v -> builder.add(v.asInt()));
                return builder.build().toArray();
            }
            if (Type.FLOAT == this.arrayType) {
                DoubleStream.Builder builder = DoubleStream.builder();
                this.values.forEach(v -> builder.add(v.asInt()));
                return builder.build().toArray();
            }
            return this.values.stream().map(Value::asObject).toArray(Object[]::new);
        });
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.assertNotFreed();
        return this.arrayType.name();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.assertNotFreed();
        return Neo4jConversions.toSqlType(this.arrayType);
    }

    @Override
    public Object getArray() throws SQLException {
        this.assertNotFreed();
        return this.array.resolve();
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        Neo4jConversions.assertTypeMap(map);
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.assertNotFreed();
        Object fullArray = this.array.resolve();
        int length = Array.getLength(fullArray);
        ArrayImpl.assertSlice(new Slice(index, count), length);
        Class<?> componentType = fullArray.getClass().getComponentType();
        Object slice = Array.newInstance(componentType, count);
        System.arraycopy(fullArray, (int)index - 1, slice, 0, count);
        return slice;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        Neo4jConversions.assertTypeMap(map);
        return this.getArray(index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.assertNotFreed();
        return new LocalStatementImpl(this.connection, ArrayImpl.defaultRunResponseKeys(), this.toPullResponse(null)).getResultSet();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        Neo4jConversions.assertTypeMap(map);
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        this.assertNotFreed();
        return new LocalStatementImpl(this.connection, ArrayImpl.defaultRunResponseKeys(), this.toPullResponse(new Slice(index, count))).getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        Neo4jConversions.assertTypeMap(map);
        return this.getResultSet(index, count);
    }

    @Override
    public void free() throws SQLException {
        if (this.freed.compareAndSet(false, true)) {
            this.array.forget();
        }
    }

    private static void assertSlice(Slice slice, int length) throws SQLException {
        int count = slice.count;
        long index = slice.index;
        if (count < 0 || index < 1L || index - 1L + (long)count > (long)length) {
            throw new Neo4jException(Neo4jException.GQLError.$22N11.withTemplatedMessage("getArray(%d, %d) for array with size %d".formatted(index, count, length)));
        }
    }

    private void assertNotFreed() throws SQLException {
        if (this.freed.get()) {
            throw new Neo4jException(Neo4jException.withReason("Array has been already freed"));
        }
    }

    private static Neo4jTransaction.RunResponse defaultRunResponseKeys() {
        return new Neo4jTransaction.RunResponse(){

            @Override
            public long queryId() {
                return 0L;
            }

            @Override
            public List<String> keys() {
                return RESULT_SET_COLUMNS;
            }
        };
    }

    private Neo4jTransaction.PullResponse toPullResponse(Slice slice) throws SQLException {
        Function<Integer, Value> recordValueSupplier;
        int length;
        if (this.arrayType == Type.BYTES) {
            byte[] byteArray = (byte[])this.array.resolve();
            length = byteArray.length;
            recordValueSupplier = i -> Values.value((int)byteArray[i]);
        } else {
            length = this.values.size();
            recordValueSupplier = this.values::get;
        }
        int start = 0;
        if (slice != null) {
            ArrayImpl.assertSlice(slice, length);
            start = (int)(slice.index - 1L);
            length = start + slice.count;
        }
        final ArrayList<Record> records = new ArrayList<Record>(length);
        for (int i2 = start; i2 < length; ++i2) {
            records.add(Record.of(RESULT_SET_COLUMNS, new Value[]{Values.value(i2 + 1), recordValueSupplier.apply(i2)}));
        }
        return new Neo4jTransaction.PullResponse(){

            @Override
            public List<Record> records() {
                return records;
            }

            @Override
            public Optional<Neo4jTransaction.ResultSummary> resultSummary() {
                return Optional.empty();
            }

            @Override
            public boolean hasMore() {
                return false;
            }
        };
    }

    private record Slice(long index, int count) {
    }
}

