/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.jdbc.Loggable;
import org.neo4j.jdbc.Neo4jStatement;
import org.neo4j.jdbc.http.HttpNeo4jConnection;
import org.neo4j.jdbc.http.HttpNeo4jResultSet;
import org.neo4j.jdbc.http.driver.Neo4jResponse;

public class HttpNeo4jStatement
extends Neo4jStatement
implements Loggable {
    public HttpNeo4jStatement(HttpNeo4jConnection httpConnection) {
        super(httpConnection);
        this.batchStatements = new ArrayList();
    }

    @Override
    public ResultSet executeQuery(String cypher) throws SQLException {
        this.execute(cypher);
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String cypher) throws SQLException {
        this.execute(cypher);
        return this.currentUpdateCount;
    }

    @Override
    public boolean execute(String cypher) throws SQLException {
        this.checkClosed();
        Neo4jResponse response = ((HttpNeo4jConnection)this.getConnection()).executeQuery(cypher, null, Boolean.TRUE);
        if (response.hasErrors()) {
            throw new SQLException(response.displayErrors());
        }
        this.currentUpdateCount = response.getFirstResult().getUpdateCount();
        boolean hasResultSets = response.hasResultSets();
        this.currentResultSet = hasResultSets ? new HttpNeo4jResultSet(this, response.getFirstResult()) : null;
        return hasResultSets;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < this.batchStatements.size(); ++i) {
            parameters.add(new HashMap());
        }
        Neo4jResponse response = ((HttpNeo4jConnection)this.getConnection()).executeQueries(this.batchStatements, parameters, Boolean.TRUE);
        int[] result = new int[response.getResults().size()];
        for (int i = 0; i < response.getResults().size(); ++i) {
            result[i] = response.getResults().get(i).getUpdateCount();
        }
        if (response.getErrors() != null && response.getErrors().size() > 0) {
            throw new BatchUpdateException(result, response.getErrors().get(0).getCause());
        }
        if (response.getResults().size() != this.batchStatements.size()) {
            throw new BatchUpdateException("Result size doesn't match queries size", result);
        }
        return result;
    }
}

