/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http;

import java.sql.Array;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.jdbc.Neo4jResultSetMetaData;
import org.neo4j.jdbc.http.driver.Neo4jResult;

public class HttpNeo4jResultSetMetaData
extends Neo4jResultSetMetaData {
    private Neo4jResult result;
    private static final Map<Class, Class> CLASSES_ASSOCIATIONS = new HashMap<Class, Class>();
    private static final Map<Class, Integer> TYPES_ASSOCIATIONS = new HashMap<Class, Integer>();

    HttpNeo4jResultSetMetaData(Neo4jResult result) {
        super(result.getColumns());
        this.result = result;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Object object = this.extractObject(column);
        if (object == null) {
            return 0;
        }
        for (Map.Entry<Class, Integer> entry : TYPES_ASSOCIATIONS.entrySet()) {
            if (!entry.getKey().isInstance(object)) continue;
            return entry.getValue();
        }
        return 2000;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Object object = this.extractObject(column);
        if (object == null) {
            return null;
        }
        for (Map.Entry<Class, Class> entry : CLASSES_ASSOCIATIONS.entrySet()) {
            if (!entry.getKey().isInstance(object)) continue;
            return entry.getValue().getName();
        }
        return Object.class.getName();
    }

    private Object extractObject(int column) {
        if (this.result == null) {
            return null;
        }
        if (this.result.getRows() == null || this.result.getRows().isEmpty()) {
            return null;
        }
        Map map = this.result.getRows().get(0);
        if (!map.containsKey("row")) {
            return null;
        }
        Object row = map.get("row");
        if (!(row instanceof List)) {
            return null;
        }
        List rowList = (List)row;
        if (rowList.size() < column) {
            return null;
        }
        return rowList.get(column - 1);
    }

    static {
        CLASSES_ASSOCIATIONS.put(String.class, String.class);
        CLASSES_ASSOCIATIONS.put(Integer.class, Long.class);
        CLASSES_ASSOCIATIONS.put(Long.class, Long.class);
        CLASSES_ASSOCIATIONS.put(Boolean.class, Boolean.class);
        CLASSES_ASSOCIATIONS.put(Float.class, Double.class);
        CLASSES_ASSOCIATIONS.put(Double.class, Double.class);
        CLASSES_ASSOCIATIONS.put(Map.class, Map.class);
        CLASSES_ASSOCIATIONS.put(List.class, Array.class);
        TYPES_ASSOCIATIONS.put(String.class, 12);
        TYPES_ASSOCIATIONS.put(Integer.class, 4);
        TYPES_ASSOCIATIONS.put(Long.class, 4);
        TYPES_ASSOCIATIONS.put(Boolean.class, 16);
        TYPES_ASSOCIATIONS.put(Float.class, 6);
        TYPES_ASSOCIATIONS.put(Double.class, 6);
        TYPES_ASSOCIATIONS.put(Map.class, 2000);
        TYPES_ASSOCIATIONS.put(List.class, 2003);
    }
}

