/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.jdbc.Neo4jArray;
import org.neo4j.jdbc.Neo4jResultSet;
import org.neo4j.jdbc.Neo4jResultSetMetaData;
import org.neo4j.jdbc.Neo4jStatement;
import org.neo4j.jdbc.http.HttpNeo4jResultSetMetaData;
import org.neo4j.jdbc.http.driver.Neo4jResult;
import org.neo4j.jdbc.impl.ListArray;

public class HttpNeo4jResultSet
extends Neo4jResultSet {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    Neo4jResult result;
    private int row = -1;
    private List<Object> currentRow;
    private Neo4jStatement statement;
    private static final String INVALID_COLUMN = "Column %s is invalid";
    private static final String UNDEFINED_COLUMN = "Column %s is not defined";
    private static final String COLUMN_NOT_ARRAY = "Column %s is not an array";

    public HttpNeo4jResultSet(Neo4jStatement statement, Neo4jResult result) {
        super(statement, new int[0]);
        this.statement = statement;
        this.result = result;
        this.row = -1;
    }

    private Object get(int column) throws SQLDataException {
        if (column < 1 || column > this.result.getColumns().size()) {
            throw new SQLDataException(String.format(INVALID_COLUMN, column));
        }
        Object value = this.currentRow.get(column - 1);
        this.wasNull = value == null;
        return value;
    }

    private Number getNumber(int columnIndex) throws SQLException {
        Number num = null;
        Object value = this.get(columnIndex);
        if (value != null) {
            if (value instanceof Number) {
                num = (Number)value;
            } else {
                throw new SQLDataException("Value is not a number" + value);
            }
        }
        return num;
    }

    @Override
    protected boolean innerNext() throws SQLException {
        this.checkClosed();
        ++this.row;
        if (this.row < this.result.getRows().size()) {
            this.currentRow = (List)this.result.getRows().get(this.row).get("row");
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.result = null;
        this.row = -1;
        this.isClosed = true;
        this.currentRow = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    @Override
    public Neo4jResultSetMetaData getMetaData() throws SQLException {
        return new HttpNeo4jResultSetMetaData(this.result);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String object = null;
        this.checkClosed();
        Object value = this.get(columnIndex);
        if (value != null) {
            Class<?> type = value.getClass();
            object = this.getObjectByTypeAndValue(type, value);
        }
        return object;
    }

    private String getObjectByTypeAndValue(Class<?> type, Object value) throws SQLException {
        String object;
        if (String.class.equals(type)) {
            object = (String)value;
        } else if (type.isPrimitive() || Number.class.isAssignableFrom(type)) {
            object = value.toString();
        } else {
            try {
                object = OBJECT_MAPPER.writeValueAsString(value);
            }
            catch (Exception e) {
                throw new SQLException("Couldn't convert value " + value + " of type " + type + " to JSON " + e.getMessage(), e);
            }
        }
        return object;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        Boolean hasResults = (Boolean)this.get(columnIndex);
        if (hasResults == null) {
            return false;
        }
        return hasResults;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        if (this.getNumber(columnIndex) == null) {
            return 0;
        }
        return this.getNumber(columnIndex).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        if (this.getNumber(columnIndex) == null) {
            return 0;
        }
        return this.getNumber(columnIndex).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        if (this.getNumber(columnIndex) == null) {
            return 0L;
        }
        return this.getNumber(columnIndex).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        if (this.getNumber(columnIndex) == null) {
            return 0.0f;
        }
        return this.getNumber(columnIndex).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        if (this.getNumber(columnIndex) == null) {
            return 0.0;
        }
        return this.getNumber(columnIndex).doubleValue();
    }

    @Override
    public Neo4jArray getArray(int columnIndex) throws SQLException {
        this.checkClosed();
        List<Object> results = new ArrayList();
        Object obj = this.get(columnIndex);
        if (obj != null) {
            if (obj.getClass().isArray()) {
                results = Arrays.asList((Neo4jArray)obj);
            } else if (obj instanceof List) {
                results = (List)obj;
            } else {
                throw new SQLException(String.format(COLUMN_NOT_ARRAY, columnIndex));
            }
        }
        Object objType = results.isEmpty() ? new Object() : results.get(0);
        return new ListArray(results, Neo4jArray.getObjectType(objType));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        Object obj = this.get(columnIndex);
        return this.convertValue(obj);
    }

    private Map<String, Object> convertPoint(Map<String, Object> objMap) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        Map crs = (Map)objMap.get("crs");
        Long srid = (Long)crs.get("srid");
        List coordinates = (List)objMap.get("coordinates");
        converted.put("srid", srid.intValue());
        converted.put("crs", crs.get("name"));
        converted.put("x", coordinates.get(0));
        converted.put("y", coordinates.get(1));
        if (coordinates.size() > 2) {
            converted.put("z", coordinates.get(2));
        }
        if (srid == 4326L || srid == 4979L) {
            converted.put("longitude", coordinates.get(0));
            converted.put("latitude", coordinates.get(1));
            if (coordinates.size() > 2) {
                converted.put("height", coordinates.get(2));
            }
        }
        return converted;
    }

    private Object convertValue(Object obj) {
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            if (objMap.containsKey("type") && "Point".equals(objMap.get("type"))) {
                return this.convertPoint(objMap);
            }
            HashMap<String, Object> converted = new HashMap<String, Object>(objMap.size());
            for (Map.Entry entry : objMap.entrySet()) {
                converted.put((String)entry.getKey(), this.convertValue(entry.getValue()));
            }
            return converted;
        }
        if (obj instanceof List) {
            List objList = (List)obj;
            ArrayList<Object> converted = new ArrayList<Object>(objList.size());
            for (Object o : objList) {
                converted.add(this.convertValue(o));
            }
            return converted;
        }
        return obj;
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public Neo4jArray getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        int index = -1;
        if (columnLabel != null) {
            index = this.result.getColumns().indexOf(columnLabel);
        }
        if (index == -1) {
            throw new SQLException(String.format(UNDEFINED_COLUMN, columnLabel));
        }
        return index + 1;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
    }
}

