/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.cache;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.jdbc.bolt.cache.BoltDriverCacheKey;
import org.neo4j.jdbc.bolt.cache.BoltDriverCached;

public class BoltDriverCache {
    private final Map<BoltDriverCacheKey, Driver> cache;
    private final Function<BoltDriverCacheKey, Driver> builder;

    public BoltDriverCache(Function<BoltDriverCacheKey, Driver> builder) {
        this.builder = builder;
        this.cache = new ConcurrentHashMap<BoltDriverCacheKey, Driver>();
    }

    public Driver getDriver(List<URI> routingUris, Config config, AuthToken authToken, Properties info) {
        return this.cache.computeIfAbsent(new BoltDriverCacheKey(routingUris, config, authToken, info), key -> new BoltDriverCached(this.builder.apply((BoltDriverCacheKey)key), this, (BoltDriverCacheKey)key));
    }

    public Driver removeFromCache(BoltDriverCacheKey key) {
        return this.cache.remove(key);
    }

    public Map<BoltDriverCacheKey, Driver> getCache() {
        return Collections.unmodifiableMap(this.cache);
    }
}

