/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.types.Type;
import org.neo4j.jdbc.Neo4jResultSetMetaData;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;

public class BoltNeo4jResultSetMetaData
extends Neo4jResultSetMetaData {
    private Type[] columnType;
    private static final Map<Type, Class> INTERNAL_TYPE_TO_CLASS_MAP = new HashMap<Type, Class>();
    private static final Map<Type, Integer> INTERNAL_TYPE_TO_SQL_TYPES_MAP = new HashMap<Type, Integer>();

    private BoltNeo4jResultSetMetaData(List<Type> types, List<String> keys) {
        super(keys);
        this.columnType = types.toArray(new Type[this.keys.size() + 1]);
    }

    public static ResultSetMetaData newInstance(boolean debug, List<Type> types, List<String> keys) {
        BoltNeo4jResultSetMetaData rsmd = new BoltNeo4jResultSetMetaData(types, keys);
        return (ResultSetMetaData)Proxy.newProxyInstance(BoltNeo4jResultSetMetaData.class.getClassLoader(), new Class[]{ResultSetMetaData.class}, (InvocationHandler)new Neo4jInvocationHandler(rsmd, debug));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.keys.size();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Type type = this.columnType[column - 1];
        if (InternalTypeSystem.TYPE_SYSTEM.NULL().equals(type)) {
            return null;
        }
        if (INTERNAL_TYPE_TO_CLASS_MAP.containsKey(type)) {
            return INTERNAL_TYPE_TO_CLASS_MAP.get(type).getName();
        }
        return Object.class.getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Type type = this.columnType[column - 1];
        if (INTERNAL_TYPE_TO_SQL_TYPES_MAP.containsKey(type)) {
            return INTERNAL_TYPE_TO_SQL_TYPES_MAP.get(type);
        }
        return 2000;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (column > this.getColumnCount()) {
            throw new SQLException("Column index out of bound");
        }
        Type type = this.columnType[column - 1];
        return type.name();
    }

    static {
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.STRING(), String.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.INTEGER(), Long.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.BOOLEAN(), Boolean.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.FLOAT(), Double.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.NODE(), Object.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.RELATIONSHIP(), Object.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.PATH(), Object.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.MAP(), Map.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.ANY(), Object.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.LIST(), Array.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.NUMBER(), Double.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.DATE(), Date.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.DATE_TIME(), Timestamp.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.LOCAL_DATE_TIME(), Timestamp.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.TIME(), Time.class);
        INTERNAL_TYPE_TO_CLASS_MAP.put(InternalTypeSystem.TYPE_SYSTEM.LOCAL_TIME(), Time.class);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.STRING(), 12);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.INTEGER(), 4);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.BOOLEAN(), 16);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.FLOAT(), 6);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.NODE(), 2000);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.RELATIONSHIP(), 2000);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.PATH(), 2000);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.MAP(), 2000);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.ANY(), 2000);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.NULL(), 0);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.LIST(), 2003);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.NUMBER(), 6);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.DATE(), 91);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.DATE_TIME(), 2014);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.LOCAL_DATE_TIME(), 93);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.TIME(), 92);
        INTERNAL_TYPE_TO_SQL_TYPES_MAP.put(InternalTypeSystem.TYPE_SYSTEM.LOCAL_TIME(), 92);
    }
}

