/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.lang.invoke.VarHandle;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.OffHeapPageLock;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.util.FeatureToggles;

class PageList
implements PageReferenceTranslator {
    private static final boolean forceSlowMemoryClear = FeatureToggles.flag(PageList.class, (String)"forceSlowMemoryClear", (boolean)false);
    static final int META_DATA_BYTES_PER_PAGE = 32;
    static final long MAX_PAGES = Integer.MAX_VALUE;
    private static final long UNBOUND_LAST_MODIFIED_TX_ID = 0L;
    private static final long MAX_USAGE_COUNT = 4L;
    private static final int SHIFT_FILE_PAGE_ID = 24;
    private static final int SHIFT_SWAPPER_ID = 3;
    private static final int SHIFT_PARTIAL_FILE_PAGE_ID = 21;
    private static final long MASK_USAGE_COUNT = 7L;
    private static final long MASK_NOT_FILE_PAGE_ID = 0xFFFFFFL;
    private static final long MASK_SHIFTED_SWAPPER_ID = 0x1FFFFFL;
    private static final long MASK_NOT_SWAPPER_ID = -16777209L;
    private static final long UNBOUND_PAGE_BINDING = -16777216L;
    private static final long MAX_FILE_PAGE_ID = 0xFFFFFFFFFFL;
    private static final int OFFSET_LOCK_WORD = 0;
    private static final int OFFSET_ADDRESS = 8;
    private static final int OFFSET_LAST_TX_ID = 16;
    private static final int OFFSET_PREVIOUS_CHAIN_TX_ID = 16;
    private static final int OFFSET_PAGE_BINDING = 24;
    private static final int UNKNOWN_CHAIN_MODIFIER = 0;
    private final int pageCount;
    private final int cachePageSize;
    private final MemoryAllocator memoryAllocator;
    private final SwapperSet swappers;
    private final long victimPageAddress;
    private final long baseAddress;
    private final long bufferAlignment;

    PageList(int pageCount, int cachePageSize, MemoryAllocator memoryAllocator, SwapperSet swappers, long victimPageAddress, long bufferAlignment) {
        this.pageCount = pageCount;
        this.cachePageSize = cachePageSize;
        this.memoryAllocator = memoryAllocator;
        this.swappers = swappers;
        this.victimPageAddress = victimPageAddress;
        long bytes = (long)pageCount * 32L;
        this.baseAddress = memoryAllocator.allocateAligned(bytes, 8L);
        this.bufferAlignment = bufferAlignment;
        PageList.clearMemory(this.baseAddress, pageCount);
    }

    PageList(PageList pageList) {
        this.pageCount = pageList.pageCount;
        this.cachePageSize = pageList.cachePageSize;
        this.memoryAllocator = pageList.memoryAllocator;
        this.swappers = pageList.swappers;
        this.victimPageAddress = pageList.victimPageAddress;
        this.baseAddress = pageList.baseAddress;
        this.bufferAlignment = pageList.bufferAlignment;
    }

    private static void clearMemory(long baseAddress, long pageCount) {
        long memcpyChunkSize = UnsafeUtil.pageSize();
        long metaDataEntriesPerChunk = memcpyChunkSize / 32L;
        if (pageCount < metaDataEntriesPerChunk || forceSlowMemoryClear) {
            PageList.clearMemorySimple(baseAddress, pageCount);
        } else {
            PageList.clearMemoryFast(baseAddress, pageCount, memcpyChunkSize, metaDataEntriesPerChunk);
        }
        VarHandle.fullFence();
    }

    private static void clearMemorySimple(long baseAddress, long pageCount) {
        long address = baseAddress - 8L;
        long initialLockWord = OffHeapPageLock.initialLockWordWithExclusiveLock();
        for (long i = 0L; i < pageCount; ++i) {
            UnsafeUtil.putLong((long)(address += 8L), (long)initialLockWord);
            UnsafeUtil.putLong((long)(address += 8L), (long)0L);
            UnsafeUtil.putLong((long)(address += 8L), (long)0L);
            UnsafeUtil.putLong((long)(address += 8L), (long)-16777216L);
        }
    }

    private static void clearMemoryFast(long baseAddress, long pageCount, long memcpyChunkSize, long metaDataEntriesPerChunk) {
        PageList.clearMemorySimple(baseAddress, metaDataEntriesPerChunk);
        long chunkCopies = pageCount / metaDataEntriesPerChunk - 1L;
        long address = baseAddress + memcpyChunkSize;
        int i = 0;
        while ((long)i < chunkCopies) {
            UnsafeUtil.copyMemory((long)baseAddress, (long)address, (long)memcpyChunkSize);
            address += memcpyChunkSize;
            ++i;
        }
        long tailCount = pageCount % metaDataEntriesPerChunk;
        PageList.clearMemorySimple(address, tailCount);
    }

    int getPageCount() {
        return this.pageCount;
    }

    SwapperSet getSwappers() {
        return this.swappers;
    }

    long deref(int pageId) {
        assert (pageId >= 0 && pageId < this.pageCount) : "PageId out of range: " + pageId + ". PageCount: " + this.pageCount;
        long id = pageId;
        return this.baseAddress + id * 32L;
    }

    @Override
    public int toId(long pageRef) {
        return (int)(pageRef - this.baseAddress >> 5);
    }

    private static long offLastModifiedTransactionId(long pageRef) {
        return pageRef + 16L;
    }

    private static long offPageHorizon(long pageRef) {
        return pageRef + 16L;
    }

    private static long offLock(long pageRef) {
        return pageRef + 0L;
    }

    private static long offAddress(long pageRef) {
        return pageRef + 8L;
    }

    private static long offPageBinding(long pageRef) {
        return pageRef + 24L;
    }

    static long tryOptimisticReadLock(long pageRef) {
        return OffHeapPageLock.tryOptimisticReadLock(PageList.offLock(pageRef));
    }

    static boolean validateReadLock(long pageRef, long stamp) {
        return OffHeapPageLock.validateReadLock(PageList.offLock(pageRef), stamp);
    }

    static boolean isModified(long pageRef) {
        return OffHeapPageLock.isModified(PageList.offLock(pageRef));
    }

    static boolean isExclusivelyLocked(long pageRef) {
        return OffHeapPageLock.isExclusivelyLocked(PageList.offLock(pageRef));
    }

    static boolean isWriteLocked(long pageRef) {
        return OffHeapPageLock.isWriteLocked(PageList.offLock(pageRef));
    }

    static boolean tryWriteLock(long pageRef, boolean multiVersioned) {
        return OffHeapPageLock.tryWriteLock(PageList.offLock(pageRef), multiVersioned);
    }

    static void unlockWrite(long pageRef) {
        OffHeapPageLock.unlockWrite(PageList.offLock(pageRef));
    }

    static long unlockWriteAndTryTakeFlushLock(long pageRef) {
        return OffHeapPageLock.unlockWriteAndTryTakeFlushLock(PageList.offLock(pageRef));
    }

    static boolean tryExclusiveLock(long pageRef) {
        return OffHeapPageLock.tryExclusiveLock(PageList.offLock(pageRef));
    }

    static long unlockExclusive(long pageRef) {
        return OffHeapPageLock.unlockExclusive(PageList.offLock(pageRef));
    }

    static void unlockExclusiveAndTakeWriteLock(long pageRef) {
        OffHeapPageLock.unlockExclusiveAndTakeWriteLock(PageList.offLock(pageRef));
    }

    static long tryFlushLock(long pageRef) {
        return OffHeapPageLock.tryFlushLock(PageList.offLock(pageRef));
    }

    static void unlockFlush(long pageRef, long stamp, boolean success) {
        OffHeapPageLock.unlockFlush(PageList.offLock(pageRef), stamp, success);
    }

    static void explicitlyMarkPageUnmodifiedUnderExclusiveLock(long pageRef) {
        OffHeapPageLock.explicitlyMarkPageUnmodifiedUnderExclusiveLock(PageList.offLock(pageRef));
    }

    int getCachePageSize() {
        return this.cachePageSize;
    }

    static long getAddress(long pageRef) {
        return UnsafeUtil.getLong((long)PageList.offAddress(pageRef));
    }

    long initBuffer(long pageRef) {
        long address = PageList.getAddress(pageRef);
        if (address == 0L) {
            address = this.memoryAllocator.allocateAligned(this.getCachePageSize(), this.bufferAlignment);
            UnsafeUtil.putLong((long)PageList.offAddress(pageRef), (long)address);
        }
        return address;
    }

    static void incrementUsage(long pageRef) {
        long address = PageList.offPageBinding(pageRef);
        long value = UnsafeUtil.getLongVolatile((long)address);
        long usage = value & 7L;
        if (usage < 4L) {
            long update = value + 1L;
            UnsafeUtil.compareAndSwapLong(null, (long)address, (long)value, (long)update);
        }
    }

    static boolean decrementUsage(long pageRef) {
        long address = PageList.offPageBinding(pageRef);
        long value = UnsafeUtil.getLongVolatile((long)address);
        long usage = value & 7L;
        if (usage > 0L) {
            long update = value - 1L;
            UnsafeUtil.compareAndSwapLong(null, (long)address, (long)value, (long)update);
        }
        return usage <= 1L;
    }

    static long getUsage(long pageRef) {
        return UnsafeUtil.getLongVolatile((long)PageList.offPageBinding(pageRef)) & 7L;
    }

    static long getFilePageId(long pageRef) {
        long filePageId = UnsafeUtil.getLong((long)PageList.offPageBinding(pageRef)) >>> 24;
        return filePageId == 0xFFFFFFFFFFL ? -1L : filePageId;
    }

    static void setFilePageId(long pageRef, long filePageId) {
        if (filePageId > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("File page id: %s is bigger then max supported value %s.", filePageId, 0xFFFFFFFFFFL));
        }
        long address = PageList.offPageBinding(pageRef);
        long v = UnsafeUtil.getLong((long)address);
        filePageId = (filePageId << 24) + (v & 0xFFFFFFL);
        UnsafeUtil.putLong((long)address, (long)filePageId);
    }

    static long getLastModifiedTxId(long pageRef) {
        return UnsafeUtil.getLongVolatile((long)PageList.offLastModifiedTransactionId(pageRef));
    }

    static long getAndResetLastModifiedTransactionId(long pageRef) {
        return UnsafeUtil.getAndSetLong(null, (long)PageList.offLastModifiedTransactionId(pageRef), (long)0L);
    }

    static void setLastModifiedTxId(long pageRef, long modifierTxId) {
        UnsafeUtil.compareAndSetMaxLong(null, (long)PageList.offLastModifiedTransactionId(pageRef), (long)modifierTxId);
    }

    static long getAndResetPageHorizon(long pageRef) {
        return UnsafeUtil.getAndSetLong(null, (long)PageList.offPageHorizon(pageRef), (long)0L);
    }

    static long getPageHorizon(long pageRef) {
        return UnsafeUtil.getLongVolatile((long)PageList.offPageHorizon(pageRef));
    }

    static void setPageHorizon(long pageRef, long horizon) {
        UnsafeUtil.putLong((long)PageList.offPageHorizon(pageRef), (long)horizon);
    }

    static int getSwapperId(long pageRef) {
        long v = UnsafeUtil.getLong((long)PageList.offPageBinding(pageRef)) >>> 3;
        return (int)(v & 0x1FFFFFL);
    }

    static void setSwapperId(long pageRef, int swapperId) {
        long address = PageList.offPageBinding(pageRef);
        long v = UnsafeUtil.getLong((long)address) & 0xFFFFFFFFFF000007L;
        UnsafeUtil.putLong((long)address, (long)(v + (long)(swapperId <<= 3)));
    }

    static boolean isLoaded(long pageRef) {
        return PageList.getFilePageId(pageRef) != -1L;
    }

    static boolean isBoundTo(long pageRef, int swapperId, long filePageId) {
        long expectedBinding = (filePageId << 21) + (long)swapperId;
        long address = PageList.offPageBinding(pageRef);
        long actualBinding = UnsafeUtil.getLong((long)address) >>> 3;
        return expectedBinding == actualBinding;
    }

    static void validatePageRefAndSetFilePageId(long pageRef, PageSwapper swapper, int swapperId, long filePageId) {
        assert (swapper != null);
        assert (filePageId != -1L);
        long currentFilePageId = PageList.getFilePageId(pageRef);
        int currentSwapper = PageList.getSwapperId(pageRef);
        if (currentFilePageId != -1L) {
            throw PageList.cannotFaultException(pageRef, swapper, swapperId, filePageId, currentSwapper, currentFilePageId);
        }
        PageList.setFilePageId(pageRef, filePageId);
        if (!PageList.isExclusivelyLocked(pageRef) || currentSwapper != 0) {
            throw PageList.cannotFaultException(pageRef, swapper, swapperId, filePageId, currentSwapper, currentFilePageId);
        }
    }

    static void fault(long pageRef, PageSwapper swapper, int swapperId, long filePageId, PinPageFaultEvent event) throws IOException {
        long bytesRead = swapper.read(filePageId, PageList.getAddress(pageRef));
        event.addBytesRead(bytesRead);
        PageList.setSwapperId(pageRef, swapperId);
    }

    static IllegalStateException cannotFaultException(long pageRef, PageSwapper swapper, int swapperId, long filePageId, int currentSwapper, long currentFilePageId) {
        String msg = String.format("Cannot fault page {filePageId = %s, swapper = %s (swapper id = %s)} into cache page %s. Already bound to {filePageId = %s, swapper id = %s}.", filePageId, swapper, swapperId, pageRef, currentFilePageId, currentSwapper);
        return new IllegalStateException(msg);
    }

    boolean tryEvict(long pageRef, EvictionEventOpportunity evictionOpportunity) throws IOException {
        if (PageList.tryExclusiveLock(pageRef)) {
            if (PageList.isLoaded(pageRef)) {
                try (EvictionEvent evictionEvent = evictionOpportunity.beginEviction(this.toId(pageRef));){
                    this.evict(pageRef, evictionEvent);
                    boolean bl = true;
                    return bl;
                }
            }
            PageList.unlockExclusive(pageRef);
        }
        return false;
    }

    private void evict(long pageRef, EvictionEvent evictionEvent) throws IOException {
        SwapperSet.SwapperMapping swapperMapping;
        long filePageId = PageList.getFilePageId(pageRef);
        evictionEvent.setFilePageId(filePageId);
        int swapperId = PageList.getSwapperId(pageRef);
        if (swapperId != 0 && (swapperMapping = this.swappers.getAllocation(swapperId)) != null) {
            PageSwapper swapper = swapperMapping.swapper;
            evictionEvent.setSwapper(swapper);
            if (PageList.isModified(pageRef)) {
                if (swapper.isPageFlushable(pageRef)) {
                    PageList.flushModifiedPage(pageRef, evictionEvent, filePageId, swapper, this);
                } else {
                    PageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
                }
            }
            swapper.evicted(pageRef, filePageId);
        }
        PageList.clearBinding(pageRef);
    }

    private static void flushModifiedPage(long pageRef, EvictionEvent evictionEvent, long filePageId, PageSwapper swapper, PageList pageReferenceTranslator) throws IOException {
        try (FlushEvent flushEvent = evictionEvent.beginFlush(pageRef, swapper, pageReferenceTranslator);){
            try {
                long address = PageList.getAddress(pageRef);
                long bytesWritten = swapper.write(filePageId, address);
                PageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
                flushEvent.addBytesWritten(bytesWritten);
                flushEvent.addEvictionFlushedPages(1);
            }
            catch (IOException e) {
                PageList.unlockExclusive(pageRef);
                flushEvent.setException(e);
                evictionEvent.setException(e);
                throw e;
            }
        }
    }

    static void clearBinding(long pageRef) {
        PageList.getAndResetPageHorizon(pageRef);
        UnsafeUtil.putLong((long)PageList.offPageBinding(pageRef), (long)-16777216L);
    }

    static String pageMetadata(long pageRef) {
        return "Lock word: " + Long.toHexString(UnsafeUtil.getLong((long)PageList.offLock(pageRef))) + "\nAddress: " + Long.toHexString(UnsafeUtil.getLong((long)PageList.offAddress(pageRef))) + "\nPrevious/Last TxId: " + Long.toHexString(UnsafeUtil.getLong((long)PageList.offPageHorizon(pageRef))) + "\nBinding: " + Long.toHexString(UnsafeUtil.getLong((long)PageList.offPageBinding(pageRef)));
    }
}

