/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class ByteBuffersTest {
    ByteBuffersTest() {
    }

    @Test
    void trackMemoryAllocationsForNativeByteBuffers() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 100L, 0L, null);
        ByteBuffer byteBuffer = ByteBuffers.allocateDirect((int)30, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)memoryTracker);
        try {
            Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
            Assertions.assertEquals((long)30L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)byteBuffer, (MemoryTracker)memoryTracker);
        }
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackMemoryAllocationsForHeapByteBuffers() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 100L, 0L, null);
        ByteBuffer byteBuffer = ByteBuffers.allocate((int)30, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)memoryTracker);
        try {
            Assertions.assertEquals((long)30L, (long)memoryTracker.estimatedHeapMemory());
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)byteBuffer, (MemoryTracker)memoryTracker);
        }
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void byteBufferMustThrowOutOfBoundsAfterRelease() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        buffer.get(0);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void heapByteBufferMustThrowOutOfBoundsAfterRelease() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        buffer.get(0);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void doubleFreeOfByteBufferIsOkay() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocate((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }

    @Test
    void doubleFreeOfHeapByteBufferIsOkay() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        ByteBuffer buffer = ByteBuffers.allocate((int)8, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        ByteBuffers.releaseBuffer((ByteBuffer)buffer, (MemoryTracker)tracker);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(0));
    }
}

