/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.muninn.CursorExceptionWithPreciseStackTrace;
import org.neo4j.io.pagecache.impl.muninn.LatchMap;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public abstract class MuninnPageCursor
extends PageCursor {
    private static final boolean usePreciseCursorErrorStackTraces = FeatureToggles.flag(MuninnPageCursor.class, (String)"usePreciseCursorErrorStackTraces", (boolean)false);
    private static final boolean boundsCheck = FeatureToggles.flag(MuninnPageCursor.class, (String)"boundsCheck", (boolean)true);
    private static final int BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    private static final int BYTE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(byte[].class);
    private static final int SIZE_OF_BYTE = 1;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    protected final PageCursorTracer tracer;
    protected final VersionContext versionContext;
    protected final CursorContext cursorContext;
    protected final MuninnPagedFile pagedFile;
    protected final PageSwapper swapper;
    final VersionStorage versionStorage;
    protected VersionState versionState;
    private final long victimPage;
    protected final int swapperId;
    private final int filePageSize;
    private final int pageReservedBytes;
    private final int filePayloadSize;
    private final int pf_flags;
    protected final boolean eagerFlush;
    private final boolean noFault;
    protected final boolean chainFollow;
    protected final boolean noGrow;
    private final boolean updateUsage;
    protected final boolean multiVersioned;
    protected final boolean littleEndian;
    private long currentPageId;
    protected long pinnedPageRef;
    protected long nextPageId;
    protected long pointer;
    protected long version;
    private int pageSize;
    private int payloadSize;
    private int offset;
    private int mark;
    private boolean outOfBounds;
    private boolean markOutOfBounds;
    protected boolean closed;
    protected MuninnPageCursor linkedCursor;
    protected MuninnPageCursor backLinkedCursor;
    protected JobHandle<?> preFetcher;
    private Object cursorException;
    private static final VarHandle CURRENT_PAGE_ID;

    MuninnPageCursor(MuninnPagedFile pagedFile, int pf_flags, long victimPage, CursorContext cursorContext, long pageId) {
        this.pagedFile = pagedFile;
        this.swapper = pagedFile.swapper;
        this.swapperId = pagedFile.swapperId;
        this.filePageSize = pagedFile.filePageSize;
        this.pageReservedBytes = pagedFile.pageReservedBytes();
        this.versionStorage = pagedFile.versionStorage;
        this.multiVersioned = pagedFile.multiVersioned;
        this.littleEndian = pagedFile.littleEndian;
        this.filePayloadSize = this.filePageSize - this.pageReservedBytes;
        this.pf_flags = pf_flags;
        this.eagerFlush = MuninnPageCursor.isFlagRaised(pf_flags, 64);
        this.updateUsage = !MuninnPageCursor.isFlagRaised(pf_flags, 32);
        this.noFault = MuninnPageCursor.isFlagRaised(pf_flags, 16);
        this.chainFollow = !MuninnPageCursor.isFlagRaised(pf_flags, 128);
        this.noGrow = this.noFault || MuninnPageCursor.isFlagRaised(pf_flags, 4);
        this.victimPage = victimPage;
        this.tracer = cursorContext.getCursorTracer();
        this.versionContext = cursorContext.getVersionContext();
        this.cursorContext = cursorContext;
        this.openCursor(pageId);
    }

    private void openCursor(long pageId) {
        this.nextPageId = pageId;
        this.offset = this.pageReservedBytes;
        this.pointer = this.victimPage;
        this.tracer.openCursor();
        this.storeCurrentPageId(-1L);
        this.closed = false;
    }

    private static boolean isFlagRaised(int flagSet, int flag) {
        return (flagSet & flag) == flag;
    }

    protected long loadPlainCurrentPageId() {
        return this.currentPageId;
    }

    long loadVolatileCurrentPageId() {
        return CURRENT_PAGE_ID.getVolatile(this);
    }

    protected void storeCurrentPageId(long pageId) {
        CURRENT_PAGE_ID.setRelease(this, pageId);
    }

    public final void init(PinEvent pinEvent, long pageRef) {
        this.pinnedPageRef = pageRef;
        this.offset = this.pageReservedBytes;
        this.pageSize = this.filePageSize;
        this.payloadSize = this.filePayloadSize;
        this.pointer = PageList.getAddress(pageRef);
        pinEvent.setCachePageId(this.pagedFile.toId(pageRef));
        if (this.updateUsage) {
            PageList.incrementUsage(pageRef);
        }
    }

    @Override
    public final boolean next(long pageId) throws IOException {
        if (this.loadPlainCurrentPageId() == pageId) {
            this.verifyContext();
            return true;
        }
        this.nextPageId = pageId;
        return this.next();
    }

    void verifyContext() {
        if (this.multiVersioned) {
            return;
        }
        long lastClosedTransactionId = this.versionContext.lastClosedTransactionId();
        if (lastClosedTransactionId == Long.MAX_VALUE) {
            return;
        }
        if (this.isPotentiallyReadingDirtyData(lastClosedTransactionId)) {
            this.versionContext.markAsDirty();
        }
    }

    private boolean isPotentiallyReadingDirtyData(long lastClosedTransactionId) {
        long pageRef = this.pinnedPageRef;
        Preconditions.checkState((pageRef != 0L ? 1 : 0) != 0, (String)"Cursor is closed.");
        return PageList.getLastModifiedTxId(pageRef) > lastClosedTransactionId || this.pagedFile.getHighestEvictedTransactionId() > lastClosedTransactionId;
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        this.closeLinks(this);
    }

    private void closeLinks(MuninnPageCursor cursor) {
        while (cursor != null && !cursor.closed) {
            cursor.unpin();
            cursor.closed = true;
            cursor.storeCurrentPageId(-1L);
            if (this.preFetcher != null) {
                this.preFetcher.cancel();
                this.preFetcher = null;
            }
            this.tracer.closeCursor();
            cursor = cursor.linkedCursor;
        }
    }

    @Override
    public PageCursor openLinkedCursor(long pageId) {
        if (this.closed) {
            throw new IllegalStateException("Cannot open linked cursor on closed page cursor");
        }
        if (this.linkedCursor != null) {
            if (!this.linkedCursor.closed) {
                throw new IllegalStateException("Previously created linked cursor still in use");
            }
            this.linkedCursor.openCursor(pageId);
        } else {
            this.linkedCursor = (MuninnPageCursor)this.pagedFile.io(pageId, this.pf_flags, this.cursorContext);
            this.linkedCursor.backLinkedCursor = this;
        }
        return this.linkedCursor;
    }

    protected void clearPageCursorState() {
        this.clearPageReference();
        this.cursorException = null;
    }

    protected void clearPageReference() {
        this.pageSize = 0;
        this.payloadSize = 0;
        this.version = 0L;
        this.pinnedPageRef = 0L;
        this.versionState = null;
    }

    @Override
    public final long getCurrentPageId() {
        return this.loadPlainCurrentPageId();
    }

    @Override
    public Path getRawCurrentFile() {
        return this.closed ? null : this.pagedFile.path();
    }

    @Override
    public final Path getCurrentFile() {
        return this.loadPlainCurrentPageId() == -1L ? null : this.getRawCurrentFile();
    }

    @Override
    public PagedFile getPagedFile() {
        return this.pagedFile;
    }

    protected void pin(PinEvent pinEvent, long filePageId) throws IOException {
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        int chunkIndex = MuninnPagedFile.computeChunkIndex(filePageId);
        int[][] tt = this.pagedFile.translationTable;
        if (tt.length <= chunkId) {
            tt = this.pagedFile.expandCapacity(chunkId);
        }
        int[] chunk = tt[chunkId];
        while (true) {
            int mappedPageId;
            if ((mappedPageId = MuninnPagedFile.TRANSLATION_TABLE_ARRAY.getVolatile(chunk, chunkIndex)) != -1) {
                long pageRef = this.pagedFile.deref(mappedPageId);
                boolean locked = this.tryLockPage(pageRef);
                if (locked && PageList.isBoundTo(pageRef, this.swapperId, filePageId)) {
                    this.pinCursorToPage(pinEvent, pageRef, filePageId, this.swapper);
                    pinEvent.hit();
                    return;
                }
                if (locked) {
                    this.unlockPage(pageRef);
                }
            } else if (this.uncommonPin(pinEvent, filePageId, chunkIndex, chunk)) {
                return;
            }
            this.assertCursorOpenFileMappedAndGetIdOfLastPage();
        }
    }

    private boolean uncommonPin(PinEvent pinEvent, long filePageId, int chunkIndex, int[] chunk) throws IOException {
        if (this.noFault) {
            this.storeCurrentPageId(-1L);
            pinEvent.noFault();
            return true;
        }
        LatchMap.Latch latch = this.pagedFile.pageFaultLatches.takeOrAwaitLatch(filePageId);
        if (latch != null) {
            if (MuninnPagedFile.TRANSLATION_TABLE_ARRAY.getVolatile(chunk, chunkIndex) == -1) {
                long pageRef = this.pageFault(pinEvent, filePageId, this.swapper, chunkIndex, chunk, latch);
                this.pinCursorToPage(pinEvent, pageRef, filePageId, this.swapper);
                return true;
            }
            latch.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long pageFault(PinEvent pinEvent, long filePageId, PageSwapper swapper, int chunkIndex, int[] chunk, LatchMap.Latch latch) throws IOException {
        try {
            long l;
            block17: {
                PinPageFaultEvent faultEvent = pinEvent.beginPageFault(filePageId, swapper);
                try {
                    long pageRef;
                    try {
                        pageRef = this.pagedFile.grabFreeAndExclusivelyLockedPage(faultEvent);
                    }
                    catch (Throwable throwable) {
                        MuninnPageCursor.abortPageFault(throwable, chunk, chunkIndex, faultEvent);
                        throw throwable;
                    }
                    try {
                        PageList.validatePageRefAndSetFilePageId(pageRef, swapper, this.swapperId, filePageId);
                        this.assertCursorOpenFileMappedAndGetIdOfLastPage();
                        this.pagedFile.initBuffer(pageRef);
                        PageList.fault(pageRef, swapper, this.pagedFile.swapperId, filePageId, faultEvent);
                    }
                    catch (Throwable throwable) {
                        try {
                            PageList.unlockExclusive(pageRef);
                        }
                        finally {
                            MuninnPageCursor.abortPageFault(throwable, chunk, chunkIndex, faultEvent);
                        }
                        throw throwable;
                    }
                    int pageId = this.pagedFile.toId(pageRef);
                    faultEvent.setCachePageId(pageId);
                    MuninnPagedFile.TRANSLATION_TABLE_ARRAY.setVolatile(chunk, chunkIndex, pageId);
                    this.convertPageFaultLock(pageRef);
                    l = pageRef;
                    if (faultEvent == null) break block17;
                }
                catch (Throwable throwable) {
                    if (faultEvent != null) {
                        try {
                            faultEvent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                faultEvent.close();
            }
            return l;
        }
        finally {
            latch.release();
        }
    }

    private static void abortPageFault(Throwable throwable, int[] chunk, int chunkIndex, PinPageFaultEvent faultEvent) {
        MuninnPagedFile.TRANSLATION_TABLE_ARRAY.setVolatile(chunk, chunkIndex, -1);
        faultEvent.setException(throwable);
    }

    protected long assertCursorOpenFileMappedAndGetIdOfLastPage() throws FileIsNotMappedException {
        if (this.closed) {
            throw new IllegalStateException("This cursor is closed");
        }
        return this.pagedFile.getLastPageId();
    }

    protected abstract void convertPageFaultLock(long var1);

    protected abstract void pinCursorToPage(PinEvent var1, long var2, long var4, PageSwapper var6) throws FileIsNotMappedException;

    protected abstract boolean tryLockPage(long var1);

    protected abstract void unlockPage(long var1);

    private long getBoundedPointer(int offset, int size) {
        long p = this.pointer;
        long can = p + (long)offset + (long)this.pageReservedBytes;
        if (boundsCheck && (can + (long)size > p + (long)this.pageSize || can < p + (long)this.pageReservedBytes)) {
            this.outOfBounds = true;
            return this.victimPage;
        }
        return can;
    }

    private long nextBoundedPointer(int size) {
        int offset = this.offset;
        long can = this.pointer + (long)offset;
        if (boundsCheck && offset + size > this.pageSize) {
            this.outOfBounds = true;
            return this.victimPage;
        }
        return can;
    }

    @Override
    public final byte getByte() {
        long p = this.nextBoundedPointer(1);
        byte b = UnsafeUtil.getByte((long)p);
        ++this.offset;
        return b;
    }

    @Override
    public byte getByte(int offset) {
        long p = this.getBoundedPointer(offset, 1);
        return UnsafeUtil.getByte((long)p);
    }

    @Override
    public void putByte(byte value) {
        long p = this.nextBoundedPointer(1);
        UnsafeUtil.putByte((long)p, (byte)value);
        ++this.offset;
    }

    @Override
    public void putByte(int offset, byte value) {
        long p = this.getBoundedPointer(offset, 1);
        UnsafeUtil.putByte((long)p, (byte)value);
    }

    @Override
    public long getLong() {
        long p = this.nextBoundedPointer(8);
        long value = MuninnPageCursor.getLongAt(p, this.littleEndian);
        this.offset += 8;
        return value;
    }

    @Override
    public long getLong(int offset) {
        long p = this.getBoundedPointer(offset, 8);
        return MuninnPageCursor.getLongAt(p, this.littleEndian);
    }

    static long getLongAt(long p, boolean littleEndian) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long value = UnsafeUtil.getLong((long)p);
            if (UnsafeUtil.nativeByteOrderIsLittleEndian == littleEndian) {
                return value;
            }
            return Long.reverseBytes(value);
        }
        return MuninnPageCursor.getLongUnaligned(p, littleEndian);
    }

    private static long getLongUnaligned(long p, boolean littleEndian) {
        long a = UnsafeUtil.getByte((long)p) & 0xFF;
        long b = UnsafeUtil.getByte((long)(p + 1L)) & 0xFF;
        long c = UnsafeUtil.getByte((long)(p + 2L)) & 0xFF;
        long d = UnsafeUtil.getByte((long)(p + 3L)) & 0xFF;
        long e = UnsafeUtil.getByte((long)(p + 4L)) & 0xFF;
        long f = UnsafeUtil.getByte((long)(p + 5L)) & 0xFF;
        long g = UnsafeUtil.getByte((long)(p + 6L)) & 0xFF;
        long h = UnsafeUtil.getByte((long)(p + 7L)) & 0xFF;
        if (littleEndian) {
            return h << 56 | g << 48 | f << 40 | e << 32 | d << 24 | c << 16 | b << 8 | a;
        }
        return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
    }

    @Override
    public void putLong(long value) {
        long p = this.nextBoundedPointer(8);
        MuninnPageCursor.putLongAt(p, value, this.littleEndian);
        this.offset += 8;
    }

    @Override
    public void putLong(int offset, long value) {
        long p = this.getBoundedPointer(offset, 8);
        MuninnPageCursor.putLongAt(p, value, this.littleEndian);
    }

    static void putLongAt(long p, long value, boolean littleEndian) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putLong((long)p, (long)(UnsafeUtil.nativeByteOrderIsLittleEndian == littleEndian ? value : Long.reverseBytes(value)));
        } else {
            MuninnPageCursor.putLongUnaligned(value, p, littleEndian);
        }
    }

    private static void putLongUnaligned(long value, long p, boolean littleEndian) {
        if (littleEndian) {
            UnsafeUtil.putByte((long)p, (byte)((byte)value));
            UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 8)));
            UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 16)));
            UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)(value >> 24)));
            UnsafeUtil.putByte((long)(p + 4L), (byte)((byte)(value >> 32)));
            UnsafeUtil.putByte((long)(p + 5L), (byte)((byte)(value >> 40)));
            UnsafeUtil.putByte((long)(p + 6L), (byte)((byte)(value >> 48)));
            UnsafeUtil.putByte((long)(p + 7L), (byte)((byte)(value >> 56)));
        } else {
            UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 56)));
            UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 48)));
            UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 40)));
            UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)(value >> 32)));
            UnsafeUtil.putByte((long)(p + 4L), (byte)((byte)(value >> 24)));
            UnsafeUtil.putByte((long)(p + 5L), (byte)((byte)(value >> 16)));
            UnsafeUtil.putByte((long)(p + 6L), (byte)((byte)(value >> 8)));
            UnsafeUtil.putByte((long)(p + 7L), (byte)((byte)value));
        }
    }

    @Override
    public int getInt() {
        long p = this.nextBoundedPointer(4);
        int i = MuninnPageCursor.getIntAt(p, this.littleEndian);
        this.offset += 4;
        return i;
    }

    @Override
    public int getInt(int offset) {
        long p = this.getBoundedPointer(offset, 4);
        return MuninnPageCursor.getIntAt(p, this.littleEndian);
    }

    private static int getIntAt(long p, boolean littleEndian) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            int x = UnsafeUtil.getInt((long)p);
            return UnsafeUtil.nativeByteOrderIsLittleEndian == littleEndian ? x : Integer.reverseBytes(x);
        }
        return MuninnPageCursor.getIntUnaligned(p, littleEndian);
    }

    private static int getIntUnaligned(long p, boolean littleEndian) {
        int a = UnsafeUtil.getByte((long)p) & 0xFF;
        int b = UnsafeUtil.getByte((long)(p + 1L)) & 0xFF;
        int c = UnsafeUtil.getByte((long)(p + 2L)) & 0xFF;
        int d = UnsafeUtil.getByte((long)(p + 3L)) & 0xFF;
        if (littleEndian) {
            return d << 24 | c << 16 | b << 8 | a;
        }
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Override
    public void putInt(int value) {
        long p = this.nextBoundedPointer(4);
        MuninnPageCursor.putIntAt(p, value, this.littleEndian);
        this.offset += 4;
    }

    @Override
    public void putInt(int offset, int value) {
        long p = this.getBoundedPointer(offset, 4);
        MuninnPageCursor.putIntAt(p, value, this.littleEndian);
    }

    private static void putIntAt(long p, int value, boolean littleEndian) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putInt((long)p, (int)(UnsafeUtil.nativeByteOrderIsLittleEndian == littleEndian ? value : Integer.reverseBytes(value)));
        } else {
            MuninnPageCursor.putIntUnaligned(value, p, littleEndian);
        }
    }

    private static void putIntUnaligned(int value, long p, boolean littleEndian) {
        if (littleEndian) {
            UnsafeUtil.putByte((long)p, (byte)((byte)value));
            UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 8)));
            UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 16)));
            UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)(value >> 24)));
        } else {
            UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 24)));
            UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 16)));
            UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 8)));
            UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)value));
        }
    }

    @Override
    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    @Override
    public void getBytes(byte[] data, int arrayOffset, int length) {
        if (arrayOffset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long p = this.nextBoundedPointer(length);
        if (!this.outOfBounds) {
            int inset = UnsafeUtil.arrayOffset((int)arrayOffset, (int)BYTE_ARRAY_BASE_OFFSET, (int)BYTE_ARRAY_INDEX_SCALE);
            if (length < 16) {
                for (int i = 0; i < length; ++i) {
                    UnsafeUtil.putByte((Object)data, (long)(inset + i), (byte)UnsafeUtil.getByte((long)(p + (long)i)));
                }
            } else {
                UnsafeUtil.copyMemory(null, (long)p, (Object)data, (long)inset, (long)length);
            }
        }
        this.offset += length;
    }

    @Override
    public final void putBytes(byte[] data) {
        this.putBytes(data, 0, data.length);
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        if (arrayOffset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long p = this.nextBoundedPointer(length);
        if (!this.outOfBounds) {
            int inset = UnsafeUtil.arrayOffset((int)arrayOffset, (int)BYTE_ARRAY_BASE_OFFSET, (int)BYTE_ARRAY_INDEX_SCALE);
            if (length < 16) {
                for (int i = 0; i < length; ++i) {
                    UnsafeUtil.putByte((long)(p + (long)i), (byte)UnsafeUtil.getByte((Object)data, (long)(inset + i)));
                }
            } else {
                UnsafeUtil.copyMemory((Object)data, (long)inset, null, (long)p, (long)length);
            }
        }
        this.offset += length;
    }

    @Override
    public void putBytes(int bytes, byte value) {
        long p = this.nextBoundedPointer(bytes);
        if (!this.outOfBounds) {
            UnsafeUtil.setMemory((long)p, (long)bytes, (byte)value);
        }
        this.offset += bytes;
    }

    @Override
    public final short getShort() {
        long p = this.nextBoundedPointer(2);
        short s = MuninnPageCursor.getShortAt(p, this.littleEndian);
        this.offset += 2;
        return s;
    }

    @Override
    public short getShort(int offset) {
        long p = this.getBoundedPointer(offset, 2);
        return MuninnPageCursor.getShortAt(p, this.littleEndian);
    }

    private static short getShortAt(long p, boolean littleEndian) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            short x = UnsafeUtil.getShort((long)p);
            return UnsafeUtil.nativeByteOrderIsLittleEndian == littleEndian ? x : Short.reverseBytes(x);
        }
        return MuninnPageCursor.getShortUnaligned(p, littleEndian);
    }

    private static short getShortUnaligned(long p, boolean littleEndian) {
        short a = (short)(UnsafeUtil.getByte((long)p) & 0xFF);
        short b = (short)(UnsafeUtil.getByte((long)(p + 1L)) & 0xFF);
        if (littleEndian) {
            return (short)(b << 8 | a);
        }
        return (short)(a << 8 | b);
    }

    @Override
    public void putShort(short value) {
        long p = this.nextBoundedPointer(2);
        MuninnPageCursor.putShortAt(p, value, this.littleEndian);
        this.offset += 2;
    }

    @Override
    public void putShort(int offset, short value) {
        long p = this.getBoundedPointer(offset, 2);
        MuninnPageCursor.putShortAt(p, value, this.littleEndian);
    }

    private static void putShortAt(long p, short value, boolean littleEndian) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putShort((long)p, (short)(UnsafeUtil.nativeByteOrderIsLittleEndian == littleEndian ? value : Short.reverseBytes(value)));
        } else {
            MuninnPageCursor.putShortUnaligned(value, p, littleEndian);
        }
    }

    private static void putShortUnaligned(short value, long p, boolean littleEndian) {
        if (littleEndian) {
            UnsafeUtil.putByte((long)p, (byte)((byte)value));
            UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 8)));
        } else {
            UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 8)));
            UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)value));
        }
    }

    @Override
    public void copyPage(PageCursor targetCursor) {
        if (targetCursor.getClass() != MuninnWritePageCursor.class) {
            throw new IllegalArgumentException("Target cursor must be writable");
        }
        MuninnPageCursor target = (MuninnPageCursor)targetCursor;
        if (this.pageSize != target.pageSize) {
            throw new IllegalArgumentException("Target cursor page size: " + target.pageSize + " is not equal to source cursor page size: " + this.pageSize);
        }
        UnsafeUtil.copyMemory((long)this.pointer, (long)target.pointer, (long)target.pageSize);
    }

    @Override
    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        if (targetCursor.getClass() != MuninnWritePageCursor.class) {
            throw new IllegalArgumentException("Target cursor must be writable");
        }
        MuninnPageCursor cursor = (MuninnPageCursor)targetCursor;
        int source = sourceOffset + this.pageReservedBytes;
        int target = targetOffset + this.pageReservedBytes;
        int sourcePageSize = this.pageSize;
        int targetPageSize = cursor.pageSize;
        if (source >= this.pageReservedBytes && target >= this.pageReservedBytes && source < sourcePageSize && target < targetPageSize && lengthInBytes >= 0) {
            int remainingSource = sourcePageSize - source;
            int remainingTarget = targetPageSize - target;
            int bytes = Math.min(lengthInBytes, Math.min(remainingSource, remainingTarget));
            UnsafeUtil.copyMemory((long)(this.pointer + (long)source), (long)(cursor.pointer + (long)target), (long)bytes);
            return bytes;
        }
        this.outOfBounds = true;
        return 0;
    }

    @Override
    public int copyTo(int sourceOffset, ByteBuffer buf) {
        if (buf.getClass() == UnsafeUtil.DIRECT_BYTE_BUFFER_CLASS && buf.isDirect() && !buf.isReadOnly() && UnsafeUtil.unsafeByteBufferAccessAvailable()) {
            return this.copyToDirectByteBuffer(sourceOffset, buf);
        }
        return this.copyToByteBufferByteWise(sourceOffset, buf);
    }

    private int copyToDirectByteBuffer(int sourceOffset, ByteBuffer buf) {
        int pos = buf.position();
        int bytesToCopy = Math.min(buf.limit() - pos, this.payloadSize - sourceOffset);
        long source = this.pointer + (long)sourceOffset + (long)this.pageReservedBytes;
        if (sourceOffset < this.payloadSize && sourceOffset >= 0) {
            long target = UnsafeUtil.getDirectByteBufferAddress((ByteBuffer)buf);
            UnsafeUtil.copyMemory((long)source, (long)(target + (long)pos), (long)bytesToCopy);
            buf.position(pos + bytesToCopy);
        } else {
            this.outOfBounds = true;
        }
        return bytesToCopy;
    }

    private int copyToByteBufferByteWise(int sourceOffset, ByteBuffer buf) {
        int bytesToCopy = Math.min(buf.limit() - buf.position(), this.payloadSize - sourceOffset);
        for (int i = 0; i < bytesToCopy; ++i) {
            byte b = this.getByte(sourceOffset + i);
            buf.put(b);
        }
        return bytesToCopy;
    }

    @Override
    public int copyFrom(ByteBuffer sourceBuffer, int targetOffset) {
        int bytesToCopy = Math.min(sourceBuffer.limit() - sourceBuffer.position(), this.payloadSize - targetOffset);
        for (int i = 0; i < bytesToCopy; ++i) {
            byte b = sourceBuffer.get();
            this.putByte(targetOffset + i, b);
        }
        return bytesToCopy;
    }

    @Override
    public void shiftBytes(int sourceOffset, int length, int shift) {
        int offset = sourceOffset + this.pageReservedBytes;
        int sourceEnd = offset + length;
        int targetStart = offset + shift;
        int targetEnd = offset + length + shift;
        if (offset < this.pageReservedBytes || sourceEnd > this.filePageSize || targetStart < this.pageReservedBytes || targetEnd > this.filePageSize || length < 0) {
            this.outOfBounds = true;
            return;
        }
        if (length < 16) {
            if (shift < 0) {
                this.unsafeShiftLeft(offset, sourceEnd, length, shift);
            } else {
                this.unsafeShiftRight(sourceEnd, offset, length, shift);
            }
        } else {
            UnsafeUtil.copyMemory((long)(this.pointer + (long)offset), (long)(this.pointer + (long)targetStart), (long)length);
        }
    }

    private void unsafeShiftLeft(int fromPos, int toPos, int length, int shift) {
        int longSteps = length >> 3;
        if (UnsafeUtil.allowUnalignedMemoryAccess && longSteps > 0) {
            for (int i = 0; i < longSteps; ++i) {
                long x = UnsafeUtil.getLong((long)(this.pointer + (long)fromPos));
                UnsafeUtil.putLong((long)(this.pointer + (long)fromPos + (long)shift), (long)x);
                fromPos += 8;
            }
        }
        while (fromPos < toPos) {
            byte b = UnsafeUtil.getByte((long)(this.pointer + (long)fromPos));
            UnsafeUtil.putByte((long)(this.pointer + (long)fromPos + (long)shift), (byte)b);
            ++fromPos;
        }
    }

    private void unsafeShiftRight(int fromPos, int toPos, int length, int shift) {
        int longSteps = length >> 3;
        if (UnsafeUtil.allowUnalignedMemoryAccess && longSteps > 0) {
            for (int i = 0; i < longSteps; ++i) {
                long x = UnsafeUtil.getLong((long)(this.pointer + (long)(fromPos -= 8)));
                UnsafeUtil.putLong((long)(this.pointer + (long)fromPos + (long)shift), (long)x);
            }
        }
        while (fromPos > toPos) {
            byte b = UnsafeUtil.getByte((long)(this.pointer + (long)(--fromPos)));
            UnsafeUtil.putByte((long)(this.pointer + (long)fromPos + (long)shift), (byte)b);
        }
    }

    @Override
    public void setOffset(int logicalOffset) {
        this.offset = logicalOffset + this.pageReservedBytes;
        if (this.offset < this.pageReservedBytes || this.offset > this.filePageSize) {
            this.offset = this.pageReservedBytes;
            this.outOfBounds = true;
        }
    }

    @Override
    public final int getOffset() {
        return this.offset - this.pageReservedBytes;
    }

    @Override
    public void mark() {
        this.mark = this.offset;
        this.markOutOfBounds = this.outOfBounds;
    }

    @Override
    public void setOffsetToMark() {
        this.offset = this.mark;
        this.outOfBounds = this.markOutOfBounds;
    }

    @Override
    public boolean checkAndClearBoundsFlag() {
        MuninnPageCursor cursor = this;
        boolean result = false;
        do {
            result |= cursor.outOfBounds;
            cursor.outOfBounds = false;
        } while ((cursor = cursor.linkedCursor) != null);
        return result;
    }

    @Override
    public void checkAndClearCursorException() throws CursorException {
        MuninnPageCursor cursor = this;
        do {
            Object error;
            if ((error = cursor.cursorException) == null) continue;
            MuninnPageCursor.clearCursorError(cursor);
            if (usePreciseCursorErrorStackTraces) {
                throw (CursorExceptionWithPreciseStackTrace)error;
            }
            throw new CursorException((String)error);
        } while ((cursor = cursor.linkedCursor) != null);
    }

    @Override
    public void clearCursorException() {
        MuninnPageCursor.clearCursorError(this);
    }

    private static void clearCursorError(MuninnPageCursor cursor) {
        while (cursor != null) {
            cursor.cursorException = null;
            cursor = cursor.linkedCursor;
        }
    }

    @Override
    public void raiseOutOfBounds() {
        this.outOfBounds = true;
    }

    @Override
    public void setCursorException(String message) {
        Objects.requireNonNull(message);
        this.cursorException = usePreciseCursorErrorStackTraces ? new CursorExceptionWithPreciseStackTrace(message) : message;
    }

    @Override
    public void zapPage() {
        if (this.pageSize == 0) {
            this.outOfBounds = true;
        } else {
            UnsafeUtil.setMemory((long)this.pointer, (long)this.pageSize, (byte)0);
        }
    }

    @Override
    public boolean isWriteLocked() {
        return MuninnPageCursor.isFlagRaised(this.pf_flags, 2);
    }

    @VisibleForTesting
    public long lastTxModifierId() {
        long pageRef = this.pinnedPageRef;
        Preconditions.checkState((pageRef != 0L ? 1 : 0) != 0, (String)"Cursor is closed.");
        return PageList.getLastModifiedTxId(pageRef);
    }

    abstract long lockStamp();

    public void unmapSnapshot() {
        VersionState remappedState = this.resetSnapshot();
        if (remappedState != null) {
            remappedState.close();
        }
    }

    public VersionState resetSnapshot() {
        VersionState remappedState = this.versionState;
        if (remappedState != null) {
            this.restoreState(remappedState);
            this.versionState = null;
        }
        return remappedState;
    }

    protected void restoreState(VersionState remappedState) {
        this.pinnedPageRef = remappedState.pinnedPageRef;
        this.version = remappedState.version;
        this.pointer = remappedState.pointer;
    }

    public void remapSnapshot(MuninnPageCursor cursor) {
        this.resetSnapshot();
        this.versionState = new VersionState(this.pinnedPageRef, this.version, this.pointer, this.lockStamp(), cursor);
        this.pinnedPageRef = cursor.pinnedPageRef;
        this.version = cursor.version;
        this.pointer = cursor.pointer;
    }

    @VisibleForTesting
    public int getPageSize() {
        return this.pageSize;
    }

    @VisibleForTesting
    public int getPayloadSize() {
        return this.payloadSize;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            CURRENT_PAGE_ID = l.findVarHandle(MuninnPageCursor.class, "currentPageId", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    record VersionState(long pinnedPageRef, long version, long pointer, long lockStamp, MuninnPageCursor cursor) implements AutoCloseable
    {
        @Override
        public void close() {
            this.cursor.close();
        }
    }
}

