/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.bufferpool.impl.Bucket;
import org.neo4j.io.bufferpool.impl.BucketBootstrapper;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class BucketBootstrapperTest {
    BucketBootstrapperTest() {
    }

    @Test
    void testDefaultBucketCapacitiesWith2Cpus() {
        TestBucketBootstrapper2 bootstrapper = new TestBucketBootstrapper2();
        List buckets = bootstrapper.getBuckets();
        BucketBootstrapperTest.assertCapacities(buckets, 256, 512, BucketBootstrapperTest.kb(1), BucketBootstrapperTest.kb(2), BucketBootstrapperTest.kb(4), BucketBootstrapperTest.kb(8), 16896, BucketBootstrapperTest.kb(32), BucketBootstrapperTest.kb(64), BucketBootstrapperTest.kb(128), BucketBootstrapperTest.kb(256), BucketBootstrapperTest.kb(512), BucketBootstrapperTest.kb(1024));
        BucketBootstrapperTest.assertSlices(buckets, 256, 1);
        BucketBootstrapperTest.assertSlices(buckets, 512, 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(2), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(4), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(8), 1);
        BucketBootstrapperTest.assertSlices(buckets, 16896, 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(32), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(64), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(128), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(256), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(512), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1024), 1);
    }

    @Test
    void testDefaultBucketCapacitiesWith16Cpus() {
        TestBucketBootstrapper16 bootstrapper = new TestBucketBootstrapper16();
        List buckets = bootstrapper.getBuckets();
        BucketBootstrapperTest.assertCapacities(buckets, 256, 512, BucketBootstrapperTest.kb(1), BucketBootstrapperTest.kb(2), BucketBootstrapperTest.kb(4), BucketBootstrapperTest.kb(8), 16896, BucketBootstrapperTest.kb(32), BucketBootstrapperTest.kb(64), BucketBootstrapperTest.kb(128), BucketBootstrapperTest.kb(256), BucketBootstrapperTest.kb(512), BucketBootstrapperTest.kb(1024));
        BucketBootstrapperTest.assertSlices(buckets, 256, 2);
        BucketBootstrapperTest.assertSlices(buckets, 512, 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(2), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(4), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(8), 2);
        BucketBootstrapperTest.assertSlices(buckets, 16896, 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(32), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(64), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(128), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(256), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(512), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1024), 1);
    }

    @Test
    void testDefaultBucketCapacitiesWith40Cpus() {
        TestBucketBootstrapper40 bootstrapper = new TestBucketBootstrapper40();
        List buckets = bootstrapper.getBuckets();
        BucketBootstrapperTest.assertCapacities(buckets, 256, 512, BucketBootstrapperTest.kb(1), BucketBootstrapperTest.kb(2), BucketBootstrapperTest.kb(4), BucketBootstrapperTest.kb(8), 16896, BucketBootstrapperTest.kb(32), BucketBootstrapperTest.kb(64), BucketBootstrapperTest.kb(128), BucketBootstrapperTest.kb(256), BucketBootstrapperTest.kb(512), BucketBootstrapperTest.kb(1024));
        BucketBootstrapperTest.assertSlices(buckets, 256, 5);
        BucketBootstrapperTest.assertSlices(buckets, 512, 5);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1), 5);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(2), 5);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(4), 5);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(8), 5);
        BucketBootstrapperTest.assertSlices(buckets, 16896, 5);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(32), 5);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(64), 5);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(128), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(256), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(512), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1024), 1);
    }

    private static int kb(int value) {
        return (int)ByteUnit.kibiBytes((long)value);
    }

    private static void assertSlices(List<Bucket> buckets, int bufferCapacity, int expectedSliceCount) {
        Integer sliceCount = buckets.stream().filter(bucket -> bucket.getBufferCapacity() == bufferCapacity).map(bucket -> bucket.getSlices().size()).findFirst().get();
        Assertions.assertEquals((int)expectedSliceCount, (Integer)sliceCount);
    }

    private static void assertCapacities(List<Bucket> buckets, Integer ... capacities) {
        List bucketCapacities = buckets.stream().map(Bucket::getBufferCapacity).collect(Collectors.toList());
        Assertions.assertEquals(bucketCapacities, Arrays.asList(capacities));
    }

    private static class TestBucketBootstrapper40
    extends TestBucketBootstrapper {
        private TestBucketBootstrapper40() {
        }

        protected int getAvailableCpuCount() {
            return 40;
        }
    }

    private static class TestBucketBootstrapper16
    extends TestBucketBootstrapper {
        private TestBucketBootstrapper16() {
        }

        protected int getAvailableCpuCount() {
            return 16;
        }
    }

    private static class TestBucketBootstrapper2
    extends TestBucketBootstrapper {
        private TestBucketBootstrapper2() {
        }

        protected int getAvailableCpuCount() {
            return 2;
        }
    }

    private static abstract class TestBucketBootstrapper
    extends BucketBootstrapper {
        TestBucketBootstrapper() {
            super((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }
}

