/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.IOUtils;

class IOUtilsTest {
    private final AutoCloseable faultyClosable = (AutoCloseable)Mockito.mock(AutoCloseable.class);
    private final AutoCloseable goodClosable1 = (AutoCloseable)Mockito.mock(AutoCloseable.class);
    private final AutoCloseable goodClosable2 = (AutoCloseable)Mockito.mock(AutoCloseable.class);

    IOUtilsTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Faulty closable")}).when((Object)this.faultyClosable)).close();
    }

    @Test
    void closeAllSilently() throws Exception {
        IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{this.goodClosable1, this.faultyClosable, this.goodClosable2});
        ((AutoCloseable)Mockito.verify((Object)this.goodClosable1)).close();
        ((AutoCloseable)Mockito.verify((Object)this.goodClosable2)).close();
        ((AutoCloseable)Mockito.verify((Object)this.faultyClosable)).close();
    }

    @Test
    void closeAllAndRethrowException() {
        IOException e = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.goodClosable1, this.faultyClosable, this.goodClosable2}));
        Assertions.assertThat((String)e.getMessage()).isEqualTo("Exception closing multiple resources.");
        Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(IOException.class);
    }

    @Test
    void closeMustIgnoreNullResources() throws Exception {
        AutoCloseable a = () -> {};
        Object b = null;
        AutoCloseable c = () -> {};
        IOUtils.close(IOException::new, (AutoCloseable[])new AutoCloseable[]{a, b, c});
    }
}

