/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.bufferpool.impl.MemoryMonitor;
import org.neo4j.io.bufferpool.impl.NeoByteBufferPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;

class BufferLifecycleTest {
    private final MemoryTracker memoryTracker = (MemoryTracker)Mockito.mock(MemoryTracker.class);
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final ArgumentCaptor<Runnable> collectionRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
    private NeoByteBufferPool bufferPool;

    BufferLifecycleTest() {
    }

    @BeforeEach
    void setUp() {
        this.bufferPool = new NeoByteBufferPool(null, this.jobScheduler){

            MemoryMonitor crateMemoryMonitor(MemoryPools memoryPools) {
                MemoryMonitor memoryMonitor = (MemoryMonitor)Mockito.mock(MemoryMonitor.class);
                Mockito.when((Object)memoryMonitor.getMemoryTracker()).thenReturn((Object)BufferLifecycleTest.this.memoryTracker);
                return memoryMonitor;
            }
        };
    }

    @Test
    void testBufferLifecycle() throws Exception {
        this.bufferPool.start();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler)).scheduleRecurring((Group)ArgumentMatchers.eq((Object)Group.BUFFER_POOL_MAINTENANCE), (JobMonitoringParams)ArgumentMatchers.any(), (Runnable)this.collectionRunnableCaptor.capture(), ArgumentMatchers.eq((long)20L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.SECONDS))));
        Runnable collectionRunnable = (Runnable)this.collectionRunnableCaptor.getValue();
        ByteBuffer b1 = this.bufferPool.acquire(1000);
        ByteBuffer b2 = this.bufferPool.acquire(1000);
        ByteBuffer b3 = this.bufferPool.acquire(1000);
        ByteBuffer b4 = this.bufferPool.acquire(2000);
        ByteBuffer b5 = this.bufferPool.acquire(4000);
        this.verifyAllocations(3, 1, 1);
        collectionRunnable.run();
        this.verifyReleases(0, 0, 0);
        this.bufferPool.release(b2);
        this.bufferPool.release(b3);
        this.bufferPool.release(b5);
        collectionRunnable.run();
        this.verifyReleases(0, 0, 0);
        collectionRunnable.run();
        this.verifyReleases(2, 0, 1);
        collectionRunnable.run();
        this.verifyReleases(2, 0, 1);
        ByteBuffer b6 = this.bufferPool.acquire(1000);
        ByteBuffer b7 = this.bufferPool.acquire(1000);
        this.verifyAllocations(5, 1, 1);
        this.bufferPool.release(b6);
        collectionRunnable.run();
        int newBuffers = -1;
        int maxAllocationAttempts = 100000;
        ByteBuffer b8 = null;
        while (b8 != b6) {
            b8 = this.bufferPool.acquire(1000);
            if (++newBuffers <= maxAllocationAttempts) continue;
            Assertions.fail((String)("Expected buffer " + b6 + " to be reused but was not able to get it after " + maxAllocationAttempts));
        }
        collectionRunnable.run();
        this.verifyReleases(2, 0, 1);
        this.bufferPool.release(b4);
        this.bufferPool.release(b7);
        this.bufferPool.release(b4);
        this.bufferPool.release(b8);
        this.bufferPool.stop();
        this.verifyReleases(4, 1, 1);
    }

    private void verifyAllocations(int expected1k, int expected2k, int expected4k) {
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)expected1k))).allocateNative(1024L);
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)expected2k))).allocateNative(2048L);
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)expected4k))).allocateNative(4096L);
    }

    private void verifyReleases(int expected1k, int expected2k, int expected4k) {
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)expected1k))).releaseNative(1024L);
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)expected2k))).releaseNative(2048L);
        ((MemoryTracker)Mockito.verify((Object)this.memoryTracker, (VerificationMode)Mockito.times((int)expected4k))).releaseNative(4096L);
    }
}

