/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.zip.Checksum;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.ChecksumMismatchException;
import org.neo4j.io.fs.ChecksumWriter;
import org.neo4j.io.fs.PhysicalFlushableChecksumChannel;
import org.neo4j.io.fs.PositionableChannel;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ScopedBuffer;

public class ReadAheadChannel<T extends StoreChannel>
implements ReadableChecksumChannel,
PositionableChannel {
    public static final int DEFAULT_READ_AHEAD_SIZE = Math.toIntExact(ByteUnit.kibiBytes(4L));
    private ScopedBuffer scopedBuffer;
    protected T channel;
    private final ByteBuffer aheadBuffer;
    private final int readAheadSize;
    private final Checksum checksum;
    private final ByteBuffer checksumView;

    public ReadAheadChannel(T channel, ByteBuffer byteBuffer) {
        Objects.requireNonNull(channel);
        Objects.requireNonNull(byteBuffer);
        this.aheadBuffer = byteBuffer;
        this.aheadBuffer.position(this.aheadBuffer.capacity());
        this.channel = channel;
        this.readAheadSize = this.aheadBuffer.capacity();
        this.checksumView = this.aheadBuffer.duplicate();
        this.checksum = ChecksumWriter.CHECKSUM_FACTORY.get();
    }

    public ReadAheadChannel(T channel, ScopedBuffer scopedBuffer) {
        this(channel, scopedBuffer.getBuffer());
        this.scopedBuffer = scopedBuffer;
    }

    public long position() throws IOException {
        return this.channel.position() - (long)this.aheadBuffer.remaining();
    }

    @Override
    public byte get() throws IOException {
        this.ensureDataExists(1);
        return this.aheadBuffer.get();
    }

    @Override
    public short getShort() throws IOException {
        this.ensureDataExists(2);
        return this.aheadBuffer.getShort();
    }

    @Override
    public int getInt() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getInt();
    }

    @Override
    public long getLong() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getLong();
    }

    @Override
    public float getFloat() throws IOException {
        this.ensureDataExists(4);
        return this.aheadBuffer.getFloat();
    }

    @Override
    public double getDouble() throws IOException {
        this.ensureDataExists(8);
        return this.aheadBuffer.getDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws IOException {
        int chunkSize;
        assert (length <= bytes.length);
        for (int bytesGotten = 0; bytesGotten < length; bytesGotten += chunkSize) {
            chunkSize = Math.min(this.readAheadSize >> 2, length - bytesGotten);
            this.ensureDataExists(chunkSize);
            this.aheadBuffer.get(bytes, bytesGotten, chunkSize);
        }
    }

    @Override
    public int endChecksumAndValidate() throws IOException {
        this.ensureDataExists(4);
        if (PhysicalFlushableChecksumChannel.DISABLE_WAL_CHECKSUM) {
            this.aheadBuffer.getInt();
            return -559063315;
        }
        this.checksumView.limit(this.aheadBuffer.position());
        this.checksum.update(this.checksumView);
        int calculatedChecksum = (int)this.checksum.getValue();
        int checksum = this.aheadBuffer.getInt();
        if (calculatedChecksum != checksum) {
            throw new ChecksumMismatchException(checksum, calculatedChecksum);
        }
        this.beginChecksum();
        return calculatedChecksum;
    }

    @Override
    public void beginChecksum() {
        if (PhysicalFlushableChecksumChannel.DISABLE_WAL_CHECKSUM) {
            return;
        }
        this.checksum.reset();
        this.checksumView.limit(this.checksumView.capacity());
        this.checksumView.position(this.aheadBuffer.position());
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.scopedBuffer != null) {
            this.scopedBuffer.close();
        }
    }

    private void ensureDataExists(int requestedNumberOfBytes) throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        int remaining = this.aheadBuffer.remaining();
        if (remaining >= requestedNumberOfBytes) {
            return;
        }
        if (!PhysicalFlushableChecksumChannel.DISABLE_WAL_CHECKSUM) {
            this.checksumView.limit(this.aheadBuffer.position());
            this.checksum.update(this.checksumView);
            this.checksumView.limit(this.checksumView.capacity());
            this.checksumView.position(0);
        }
        this.aheadBuffer.compact();
        while (this.aheadBuffer.position() < this.aheadBuffer.capacity()) {
            int read = this.channel.read(this.aheadBuffer);
            if (read != -1) continue;
            if (this.aheadBuffer.position() >= requestedNumberOfBytes) break;
            T nextChannel = this.next(this.channel);
            assert (nextChannel != null);
            if (nextChannel == this.channel) {
                this.aheadBuffer.flip();
                throw ReadPastEndException.INSTANCE;
            }
            this.channel = nextChannel;
        }
        this.aheadBuffer.flip();
    }

    protected T next(T channel) throws IOException {
        return channel;
    }

    @Override
    public void setCurrentPosition(long byteOffset) throws IOException {
        long positionRelativeToAheadBuffer = byteOffset - (this.channel.position() - (long)this.aheadBuffer.limit());
        if (positionRelativeToAheadBuffer >= (long)this.aheadBuffer.limit() || positionRelativeToAheadBuffer < 0L) {
            this.aheadBuffer.position(this.aheadBuffer.limit());
            this.channel.position(byteOffset);
        } else {
            this.aheadBuffer.position(Math.toIntExact(positionRelativeToAheadBuffer));
        }
        this.beginChecksum();
    }
}

