/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.Predicates;
import org.neo4j.io.fs.FileVisitors;

class OnlyMatchingFileVisitorTest {
    private final FileVisitor<Path> wrapped = (FileVisitor)Mockito.mock(FileVisitor.class);

    OnlyMatchingFileVisitorTest() {
    }

    @Test
    void shouldNotDelegatePreVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).preVisitDirectory(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).preVisitDirectory((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any());
    }

    @Test
    void shouldNotDelegatePostVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).postVisitDirectory(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).postVisitDirectory((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any());
    }

    @Test
    void shouldNotDelegateVisitFileIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFile(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).visitFile((Path)ArgumentMatchers.any(), (BasicFileAttributes)ArgumentMatchers.any());
    }

    @Test
    void shouldNotDelegateVisitFileFailedIfPredicateDoesntMatch() throws IOException {
        FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFileFailed(null, null);
        ((FileVisitor)Mockito.verify(this.wrapped, (VerificationMode)Mockito.never())).visitFileFailed((Path)ArgumentMatchers.any(), (IOException)ArgumentMatchers.any());
    }

    @Test
    void shouldNotSkipSubtreeFromPreVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        Assertions.assertThat((Comparable)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).preVisitDirectory(null, null))).isEqualTo((Object)FileVisitResult.SKIP_SUBTREE);
    }

    @Test
    void shouldContinueAfterPostVisitDirectoryIfPredicateDoesntMatch() throws IOException {
        Assertions.assertThat((Comparable)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).postVisitDirectory(null, null))).isEqualTo((Object)FileVisitResult.CONTINUE);
    }

    @Test
    void shouldContinueAfterVisitFileIfPredicateDoesntMatch() throws IOException {
        Assertions.assertThat((Comparable)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFile(null, null))).isEqualTo((Object)FileVisitResult.CONTINUE);
    }

    @Test
    void shouldContinueAfterVisitFileFailedIfPredicateDoesntMatch() throws IOException {
        Assertions.assertThat((Comparable)((Object)FileVisitors.onlyMatching((Predicate)Predicates.alwaysFalse(), this.wrapped).visitFileFailed(null, null))).isEqualTo((Object)FileVisitResult.CONTINUE);
    }
}

