/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.bufferpool.impl.Bucket;
import org.neo4j.io.bufferpool.impl.BucketBootstrapper;
import org.neo4j.io.bufferpool.impl.NeoBufferPoolConfigOverride;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class BucketBootstrapperTest {
    BucketBootstrapperTest() {
    }

    @Test
    void testBasicBucketCreation() {
        List<Bucket> buckets = BucketBootstrapperTest.constructBuckets("512:1C", "1K:1C");
        BucketBootstrapperTest.assertCapacities(buckets, 512, 1024);
        BucketBootstrapperTest.assertSlices(buckets, 512, 16);
        BucketBootstrapperTest.assertSlices(buckets, 1024, 16);
    }

    @Test
    void testSliceCalculation() {
        List<Bucket> buckets = BucketBootstrapperTest.constructBuckets("512:0.01C");
        BucketBootstrapperTest.assertSlices(buckets, 512, 1);
        buckets = BucketBootstrapperTest.constructBuckets("512:0.1C");
        BucketBootstrapperTest.assertSlices(buckets, 512, 2);
        buckets = BucketBootstrapperTest.constructBuckets("512:0.125C");
        BucketBootstrapperTest.assertSlices(buckets, 512, 2);
        buckets = BucketBootstrapperTest.constructBuckets("512:0.13C");
        BucketBootstrapperTest.assertSlices(buckets, 512, 3);
        buckets = BucketBootstrapperTest.constructBuckets("512:0.2C");
        BucketBootstrapperTest.assertSlices(buckets, 512, 4);
    }

    @Test
    void testDefaultBucketCapacities() {
        List<Bucket> buckets = BucketBootstrapperTest.constructBuckets(new String[0]);
        BucketBootstrapperTest.assertCapacities(buckets, 256, 512, BucketBootstrapperTest.kb(1), BucketBootstrapperTest.kb(2), BucketBootstrapperTest.kb(4), BucketBootstrapperTest.kb(8), 16896, BucketBootstrapperTest.kb(32), BucketBootstrapperTest.kb(64), BucketBootstrapperTest.kb(128), BucketBootstrapperTest.kb(256), BucketBootstrapperTest.kb(512), BucketBootstrapperTest.kb(1024));
        BucketBootstrapperTest.assertSlices(buckets, 256, 2);
        BucketBootstrapperTest.assertSlices(buckets, 512, 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(2), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(4), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(8), 2);
        BucketBootstrapperTest.assertSlices(buckets, 16896, 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(32), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(64), 2);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(128), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(256), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(512), 1);
        BucketBootstrapperTest.assertSlices(buckets, BucketBootstrapperTest.kb(1024), 1);
    }

    private static int kb(int value) {
        return (int)ByteUnit.kibiBytes((long)value);
    }

    private static void assertSlices(List<Bucket> buckets, int bufferCapacity, int expectedSliceCount) {
        Integer sliceCount = buckets.stream().filter(bucket -> bucket.getBufferCapacity() == bufferCapacity).map(bucket -> bucket.getSlices().size()).findFirst().get();
        Assertions.assertEquals((int)expectedSliceCount, (Integer)sliceCount);
    }

    private static List<Bucket> constructBuckets(String ... expressions) {
        NeoBufferPoolConfigOverride config = new NeoBufferPoolConfigOverride(Duration.ZERO, Arrays.asList(expressions));
        TestBucketBootstrapper bootstrapper = new TestBucketBootstrapper(config);
        return bootstrapper.getBuckets();
    }

    private static void assertCapacities(List<Bucket> buckets, Integer ... capacities) {
        List bucketCapacities = buckets.stream().map(Bucket::getBufferCapacity).collect(Collectors.toList());
        Assertions.assertEquals(bucketCapacities, Arrays.asList(capacities));
    }

    private static class TestBucketBootstrapper
    extends BucketBootstrapper {
        TestBucketBootstrapper(NeoBufferPoolConfigOverride config) {
            super(config, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        protected int getAvailableCpuCount() {
            return 16;
        }
    }
}

