/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapper;

public class SingleFilePageSwapperFactory
implements PageSwapperFactory {
    private FileSystemAbstraction fs;

    @Override
    public void open(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    @Override
    public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean noChannelStriping, boolean useDirectIO) throws IOException {
        if (!this.fs.fileExists(file)) {
            if (createIfNotExist) {
                this.fs.write(file).close();
            } else {
                throw new NoSuchFileException(file.getPath(), null, "Cannot map non-existing file");
            }
        }
        return new SingleFilePageSwapper(file, this.fs, filePageSize, onEviction, noChannelStriping, useDirectIO);
    }

    @Override
    public void close() {
    }

    public String getName() {
        return "single";
    }

    @Override
    public long getRequiredBufferAlignment() {
        return 1L;
    }
}

