/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstractionTest;

public class DefaultFileSystemAbstractionTest
extends FileSystemAbstractionTest {
    @Override
    protected FileSystemAbstraction buildFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    @Test
    void shouldFailGracefullyWhenPathCannotBeCreated() {
        this.path = new File(this.testDirectory.directory(), String.valueOf(UUID.randomUUID())){

            @Override
            public boolean mkdirs() {
                return false;
            }
        };
        IOException exception = (IOException)Assertions.assertThrows(IOException.class, () -> this.fsa.mkdirs(this.path));
        Assertions.assertFalse((boolean)this.fsa.fileExists(this.path));
        String expectedMessage = String.format("Unable to create directory path [%s] for Neo4j store.", this.path);
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Is.is((Object)expectedMessage));
    }
}

