/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.FileSystemExtension;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.rule.TestDirectory;

public class TestDirectoryExtension
extends StatefullFieldExtension<TestDirectory>
implements BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    static final String TEST_DIRECTORY = "testDirectory";
    static final ExtensionContext.Namespace TEST_DIRECTORY_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"testDirectory"});

    public void beforeEach(ExtensionContext context) throws Exception {
        TestDirectory testDirectory = (TestDirectory)((Object)this.getStoredValue(context));
        testDirectory.prepareDirectory(context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
    }

    public void afterEach(ExtensionContext context) {
        TestDirectory testDirectory = (TestDirectory)((Object)this.getStoredValue(context));
        try {
            testDirectory.complete(!context.getExecutionException().isPresent());
        }
        catch (Exception e) {
            throw new JUnitException(String.format("Fail to cleanup test directory for %s test.", context.getDisplayName()), (Throwable)e);
        }
    }

    protected String getFieldKey() {
        return TEST_DIRECTORY;
    }

    protected Class<TestDirectory> getFieldType() {
        return TestDirectory.class;
    }

    protected TestDirectory createField(ExtensionContext extensionContext) {
        ExtensionContext.Store fileSystemStore = TestDirectoryExtension.getStore((ExtensionContext)extensionContext, (ExtensionContext.Namespace)FileSystemExtension.FILE_SYSTEM_NAMESPACE);
        FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)fileSystemStore.get((Object)"fileSystem", FileSystemAbstraction.class);
        return fileSystemAbstraction != null ? TestDirectory.testDirectory(fileSystemAbstraction) : TestDirectory.testDirectory();
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return TEST_DIRECTORY_NAMESPACE;
    }
}

