/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.File;
import java.io.PrintStream;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.resources.Profiler;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

public class ProfilerExtension
extends StatefullFieldExtension<Profiler>
implements BeforeEachCallback,
AfterEachCallback {
    static final String PROFILER_KEY = "profiler";
    static final ExtensionContext.Namespace PROFILER_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"profiler"});

    protected String getFieldKey() {
        return PROFILER_KEY;
    }

    protected Class<Profiler> getFieldType() {
        return Profiler.class;
    }

    protected Profiler createField(ExtensionContext extensionContext) {
        return Profiler.profiler();
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return PROFILER_NAMESPACE;
    }

    public void beforeEach(ExtensionContext context) {
        ((Profiler)this.getStoredValue(context)).reset();
    }

    public void afterEach(ExtensionContext context) {
        block14: {
            Profiler profiler = (Profiler)this.getStoredValue(context);
            try {
                profiler.finish();
                if (!context.getExecutionException().isPresent()) break block14;
                ExtensionContext.Store testDirStore = ProfilerExtension.getStore((ExtensionContext)context, (ExtensionContext.Namespace)TestDirectoryExtension.TEST_DIRECTORY_NAMESPACE);
                TestDirectory testDir = (TestDirectory)((Object)testDirStore.get((Object)"testDirectory"));
                File profileOutputFile = testDir.createFile("profiler-output.txt");
                FileSystemAbstraction fs = testDir.getFileSystem();
                try (PrintStream out = new PrintStream(fs.openAsOutputStream(profileOutputFile, false));){
                    String displayName = context.getTestClass().map(Class::getSimpleName).orElse("class") + "." + context.getDisplayName();
                    profiler.printProfile(out, displayName);
                }
            }
            catch (Exception e) {
                throw new JUnitException("Failed to finish profiling and/or produce profiling output.", (Throwable)e);
            }
        }
    }
}

