/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.TinyLockManager;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.RecordFormat;

public class RecordStresser
implements Callable<Void> {
    private final PagedFile pagedFile;
    private final Condition condition;
    private final int maxRecords;
    private final RecordFormat format;
    private final int threadId;
    private final TinyLockManager locks;
    private long countSum;

    public RecordStresser(PagedFile pagedFile, Condition condition, int maxRecords, RecordFormat format, int threadId, TinyLockManager locks) {
        this.pagedFile = pagedFile;
        this.condition = condition;
        this.maxRecords = maxRecords;
        this.format = format;
        this.threadId = threadId;
        this.locks = locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        Random random = new Random();
        int recordsPerPage = this.format.getRecordsPerPage();
        int recordSize = this.format.getRecordSize();
        try (PageCursor cursor = this.pagedFile.io(0L, 2);){
            while (!this.condition.fulfilled()) {
                int recordId = random.nextInt(this.maxRecords);
                int pageId = recordId / recordsPerPage;
                int recordOffset = recordId % recordsPerPage * recordSize;
                this.locks.lock(recordId);
                try {
                    Assertions.assertTrue((boolean)cursor.next((long)pageId), (String)"I must be able to access pages");
                    cursor.setOffset(recordOffset);
                    long newValue = this.format.incrementCounter(cursor, this.threadId);
                    ++this.countSum;
                    Assertions.assertFalse((boolean)cursor.shouldRetry(), (String)"Write lock, so never a need to retry");
                    MatcherAssert.assertThat((String)"Record-local count must be less than or equal to thread-local count sum", (Object)newValue, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(this.countSum)));
                }
                finally {
                    this.locks.unlock(recordId);
                }
            }
        }
        return null;
    }

    public void verifyCounts() throws IOException {
        long actualSum = 0L;
        try (PageCursor cursor = this.pagedFile.io(0L, 1);){
            while (cursor.next()) {
                actualSum += this.format.sumCountsForThread(cursor, this.threadId);
            }
        }
        MatcherAssert.assertThat((String)"Thread specific sum across all records", (Object)actualSum, (Matcher)Matchers.is((Object)this.countSum));
    }
}

