/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.concurrent.CountDownLatch;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.scheduler.JobScheduler;

public class MuninnPageCacheFixture
extends PageCacheTestSupport.Fixture<MuninnPageCache> {
    CountDownLatch backgroundFlushLatch;
    private MemoryAllocator allocator;

    @Override
    public MuninnPageCache createPageCache(PageSwapperFactory swapperFactory, int maxPages, PageCacheTracer tracer, PageCursorTracerSupplier cursorTracerSupplier, VersionContextSupplier contextSupplier, JobScheduler jobScheduler) {
        long memory = MuninnPageCache.memoryRequiredForPages((long)maxPages);
        this.allocator = MemoryAllocator.createAllocator((String)String.valueOf(memory), (MemoryAllocationTracker)new LocalMemoryTracker());
        return new MuninnPageCache(swapperFactory, this.allocator, tracer, cursorTracerSupplier, contextSupplier, jobScheduler);
    }

    @Override
    public void tearDownPageCache(MuninnPageCache pageCache) {
        if (this.backgroundFlushLatch != null) {
            this.backgroundFlushLatch.countDown();
            this.backgroundFlushLatch = null;
        }
        pageCache.close();
        this.allocator.close();
    }
}

