/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.layout.StoreLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class StoreLayoutTest {
    @Inject
    private TestDirectory testDirectory;

    StoreLayoutTest() {
    }

    @Test
    void storeLayoutForAbsoluteFile() {
        File storeDir = this.testDirectory.storeDir();
        StoreLayout storeLayout = StoreLayout.of((File)storeDir);
        Assertions.assertEquals((Object)storeDir, (Object)storeLayout.storeDirectory());
    }

    @Test
    void storeLayoutResolvesLinks() throws IOException {
        Path basePath = this.testDirectory.directory().toPath();
        File storeDir = this.testDirectory.storeDir("notAbsolute");
        Path linkPath = basePath.resolve("link");
        Path symbolicLink = Files.createSymbolicLink(linkPath, storeDir.toPath(), new FileAttribute[0]);
        StoreLayout storeLayout = StoreLayout.of((File)symbolicLink.toFile());
        Assertions.assertEquals((Object)storeDir, (Object)storeLayout.storeDirectory());
    }

    @Test
    void storeLayoutUseCanonicalRepresentation() {
        Path basePath = this.testDirectory.storeDir("notCanonical").toPath();
        Path notCanonicalPath = basePath.resolve("../anotherLocation");
        StoreLayout storeLayout = StoreLayout.of((File)notCanonicalPath.toFile());
        Assertions.assertEquals((Object)this.testDirectory.directory("anotherLocation"), (Object)storeLayout.storeDirectory());
    }

    @Test
    void storeLockFileLocation() {
        StoreLayout storeLayout = this.testDirectory.storeLayout();
        File storeLockFile = storeLayout.storeLockFile();
        Assertions.assertEquals((Object)"store_lock", (Object)storeLockFile.getName());
        Assertions.assertEquals((Object)storeLayout.storeDirectory(), (Object)storeLockFile.getParentFile());
    }
}

