/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.IOException;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.test.rule.TestDirectory;

public class TestDirectoryClassExtension
implements BeforeAllCallback,
AfterAllCallback {
    private TestDirectory testDirectory;

    public void beforeAll(ExtensionContext context) throws Exception {
        this.testDirectory = TestDirectory.testDirectory();
        Class testClass = context.getRequiredTestClass();
        String testName = context.getRequiredTestClass().getName();
        this.testDirectory.prepareDirectory(testClass, testName);
    }

    public TestDirectory getTestDirectory() {
        return this.testDirectory;
    }

    public void afterAll(ExtensionContext context) {
        try {
            this.testDirectory.complete(!context.getExecutionException().isPresent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

