/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.neo4j.test.extension.ExecutionSharedContext;
import org.neo4j.test.extension.ProfilerExtensionVerificationTest;

class ProfilerExtensionTest {
    ProfilerExtensionTest() {
    }

    @Test
    void passingTestsMustNotProduceProfilerOutput() {
        ExecutionSharedContext.CONTEXT.clear();
        ProfilerExtensionTest.execute("testThatPasses", new TestExecutionListener[0]);
        File testDir = (File)ExecutionSharedContext.CONTEXT.getValue("test dir");
        Assertions.assertFalse((boolean)testDir.exists());
    }

    @Test
    void failingTestsMustProduceProfilerOutput() throws IOException {
        ExecutionSharedContext.CONTEXT.clear();
        ProfilerExtensionTest.execute("testThatFails", new TestExecutionListener[0]);
        File testDir = (File)ExecutionSharedContext.CONTEXT.getValue("test dir");
        Assertions.assertTrue((boolean)testDir.exists());
        Assertions.assertTrue((boolean)testDir.isDirectory());
        File profileData = new File(testDir, "profiler-output.txt");
        Assertions.assertTrue((boolean)profileData.exists());
        Assertions.assertTrue((boolean)profileData.isFile());
        try (Stream<String> lines = Files.lines(profileData.toPath());){
            Assertions.assertTrue((boolean)lines.anyMatch(line -> line.contains("someVeryExpensiveComputation")));
        }
    }

    private static void execute(String testName, TestExecutionListener ... testExecutionListeners) {
        LauncherDiscoveryRequest discoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod(ProfilerExtensionVerificationTest.class, (String)testName)}).configurationParameter("testToggle", "true").build();
        Launcher launcher = LauncherFactory.create();
        launcher.execute(discoveryRequest, testExecutionListeners);
    }
}

