/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.checking;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.checking.AccessCheckingPageCache;

class AccessCheckingPageCacheTest {
    private PageCache pageCache;
    private PageCursor cursor;

    AccessCheckingPageCacheTest() {
    }

    @BeforeEach
    void getPageCursor() throws IOException {
        PageCache mockedPageCache = (PageCache)Mockito.mock(PageCache.class);
        PagedFile mockedPagedFile = (PagedFile)Mockito.mock(PagedFile.class);
        PageCursor mockedCursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)mockedPagedFile.io(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenReturn((Object)mockedCursor);
        Mockito.when((Object)mockedPageCache.map((File)ArgumentMatchers.any(File.class), ArgumentMatchers.anyInt(), (OpenOption[])ArgumentMatchers.any())).thenReturn((Object)mockedPagedFile);
        this.pageCache = new AccessCheckingPageCache(mockedPageCache);
        PagedFile file = this.pageCache.map(new File("some file"), 512, new OpenOption[0]);
        this.cursor = file.io(0L, 1);
    }

    @Test
    void shouldGrant_read_shouldRetry_close() throws Exception {
        this.cursor.getByte();
        this.cursor.shouldRetry();
        this.cursor.close();
    }

    @Test
    void shouldGrant_read_shouldRetry_next() throws Exception {
        this.cursor.getByte(0);
        this.cursor.shouldRetry();
        this.cursor.next();
    }

    @Test
    void shouldGrant_read_shouldRetry_next_with_id() throws Exception {
        this.cursor.getShort();
        this.cursor.shouldRetry();
        this.cursor.next(1L);
    }

    @Test
    void shouldGrant_read_shouldRetry_read_shouldRetry_close() throws Exception {
        this.cursor.getShort(0);
        this.cursor.shouldRetry();
        this.cursor.getInt();
        this.cursor.shouldRetry();
        this.cursor.close();
    }

    @Test
    void shouldGrant_read_shouldRetry_read_shouldRetry_next() throws Exception {
        this.cursor.getInt(0);
        this.cursor.shouldRetry();
        this.cursor.getLong();
        this.cursor.shouldRetry();
        this.cursor.next();
    }

    @Test
    void shouldGrant_read_shouldRetry_read_shouldRetry_next_with_id() throws Exception {
        this.cursor.getLong(0);
        this.cursor.shouldRetry();
        this.cursor.getBytes(new byte[2]);
        this.cursor.shouldRetry();
        this.cursor.next(1L);
    }

    @Test
    void shouldFail_read_close() {
        this.cursor.getByte();
        try {
            this.cursor.close();
            Assertions.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)Matchers.containsString((String)"shouldRetry"));
        }
    }

    @Test
    void shouldFail_read_next() throws Exception {
        this.cursor.getByte(0);
        try {
            this.cursor.next();
            Assertions.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)Matchers.containsString((String)"shouldRetry"));
        }
    }

    @Test
    void shouldFail_read_next_with_id() throws Exception {
        this.cursor.getShort();
        try {
            this.cursor.next(1L);
            Assertions.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)Matchers.containsString((String)"shouldRetry"));
        }
    }

    @Test
    void shouldFail_read_shouldRetry_read_close() throws Exception {
        this.cursor.getShort(0);
        this.cursor.shouldRetry();
        this.cursor.getInt();
        try {
            this.cursor.close();
            Assertions.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)Matchers.containsString((String)"shouldRetry"));
        }
    }

    @Test
    void shouldFail_read_shouldRetry_read_next() throws Exception {
        this.cursor.getInt(0);
        this.cursor.shouldRetry();
        this.cursor.getLong();
        try {
            this.cursor.next();
            Assertions.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)Matchers.containsString((String)"shouldRetry"));
        }
    }

    @Test
    void shouldFail_read_shouldRetry_read_next_with_id() throws Exception {
        this.cursor.getLong(0);
        this.cursor.shouldRetry();
        this.cursor.getBytes(new byte[2]);
        try {
            this.cursor.next(1L);
            Assertions.fail((String)"Should have failed");
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)((Throwable)((Object)e)).getMessage(), (Matcher)Matchers.containsString((String)"shouldRetry"));
        }
    }
}

