/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.fs.FileVisitors;

@RunWith(value=MockitoJUnitRunner.class)
public class OnDirectoryTest {
    @Mock
    public ThrowingConsumer<Path, IOException> operation;
    @Mock
    public FileVisitor<Path> wrapped;

    @Test
    public void shouldOperateOnDirectories() throws IOException {
        Path dir = Paths.get("/some/path", new String[0]);
        FileVisitors.onDirectory(this.operation, this.wrapped).preVisitDirectory(dir, null);
        ((ThrowingConsumer)Mockito.verify(this.operation)).accept((Object)dir);
    }

    @Test
    public void shouldNotOperateOnFiles() throws IOException {
        Path file = Paths.get("/some/path", new String[0]);
        FileVisitors.onDirectory(this.operation, this.wrapped).visitFile(file, null);
        ((ThrowingConsumer)Mockito.verify(this.operation, (VerificationMode)Mockito.never())).accept((Object)file);
    }
}

