/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.Closeable;
import java.io.File;
import org.junit.AssumptionViolatedException;

public final class AssumptionHelper {
    private AssumptionHelper() {
    }

    public static Closeable withoutReadPermissions(File file) {
        if (!file.setReadable(false)) {
            throw new AssumptionViolatedException("User is unable to change permissions on file " + file.getAbsolutePath());
        }
        if (file.canRead()) {
            file.setReadable(true);
            throw new AssumptionViolatedException("User can read unreadable file " + file.getAbsolutePath());
        }
        return () -> file.setReadable(true);
    }

    public static Closeable withoutWritePermissions(File file) {
        if (!file.setWritable(false)) {
            throw new AssumptionViolatedException("User is unable to change permissions on file " + file.getAbsolutePath());
        }
        if (file.canWrite()) {
            file.setWritable(true);
            throw new AssumptionViolatedException("User can read unreadable file " + file.getAbsolutePath());
        }
        return () -> file.setWritable(true);
    }
}

