/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.util.concurrent.TimeUnit;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.io.pagecache.stress.Condition;

public class Conditions {
    private Conditions() {
    }

    public static Condition numberOfEvictions(PageCacheCounters monitor, long desiredNumberOfEvictions) {
        return () -> monitor.evictions() > desiredNumberOfEvictions;
    }

    public static Condition timePeriod(int duration, TimeUnit timeUnit) {
        long endTimeInMilliseconds = System.currentTimeMillis() + timeUnit.toMillis(duration);
        return () -> System.currentTimeMillis() > endTimeInMilliseconds;
    }
}

