/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPagedFile;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;

public class AdversarialPageCache
implements PageCache {
    private final PageCache delegate;
    private final Adversary adversary;

    public AdversarialPageCache(PageCache delegate, Adversary adversary) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    public PagedFile map(File file, int pageSize, OpenOption ... openOptions) throws IOException {
        if (ArrayUtils.contains((Object[])openOptions, (Object)StandardOpenOption.CREATE)) {
            this.adversary.injectFailure(IOException.class, SecurityException.class);
        } else {
            this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        }
        PagedFile pagedFile = this.delegate.map(file, pageSize, openOptions);
        return new AdversarialPagedFile(pagedFile, this.adversary);
    }

    public Optional<PagedFile> getExistingMapping(File file) throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        Optional optional = this.delegate.getExistingMapping(file);
        return optional.map(pagedFile -> new AdversarialPagedFile((PagedFile)pagedFile, this.adversary));
    }

    public List<PagedFile> listExistingMappings() throws IOException {
        this.adversary.injectFailure(IOException.class, SecurityException.class);
        List list = this.delegate.listExistingMappings();
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, new AdversarialPagedFile((PagedFile)list.get(i), this.adversary));
        }
        return list;
    }

    public void flushAndForce() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce();
    }

    public void flushAndForce(IOLimiter limiter) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class);
        this.delegate.flushAndForce(limiter);
    }

    public void close() {
        this.adversary.injectFailure(IllegalStateException.class);
        this.delegate.close();
    }

    public int pageSize() {
        return this.delegate.pageSize();
    }

    public long maxCachedPages() {
        return this.delegate.maxCachedPages();
    }

    public FileSystemAbstraction getCachedFileSystem() {
        return this.delegate.getCachedFileSystem();
    }

    public void reportEvents() {
        this.delegate.reportEvents();
    }

    public boolean fileSystemSupportsFileOperations() {
        return this.delegate.fileSystemSupportsFileOperations();
    }
}

