/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, null, PageCacheTracer.NULL, DefaultPageCursorTracerSupplier.INSTANCE);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Integer pageSize) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, pageSize, PageCacheTracer.NULL, DefaultPageCursorTracerSupplier.INSTANCE);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Integer pageSize, PageCacheTracer tracer, PageCursorTracerSupplier cursorTracerSupplier) {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.setFileSystemAbstraction(fileSystem);
        int cachePageSize = pageSize != null ? pageSize.intValue() : factory.getCachePageSizeHint();
        long pageCacheMemory = ByteUnit.mebiBytes(8L);
        long pageCount = pageCacheMemory / (long)cachePageSize;
        return new MuninnPageCache(factory, (int)pageCount, cachePageSize, tracer, cursorTracerSupplier);
    }
}

