/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ByteArrayMatcher
extends TypeSafeDiagnosingMatcher<byte[]> {
    private final byte[] expected;

    public static ByteArrayMatcher byteArray(byte ... expected) {
        return new ByteArrayMatcher(expected);
    }

    public static ByteArrayMatcher byteArray(int ... expected) {
        byte[] bytes = new byte[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            bytes[i] = (byte)expected[i];
        }
        return ByteArrayMatcher.byteArray(bytes);
    }

    public ByteArrayMatcher(byte[] expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(byte[] actual, Description description) {
        this.describe(actual, description);
        if (actual.length != this.expected.length) {
            return false;
        }
        for (int i = 0; i < this.expected.length; ++i) {
            if (actual[i] == this.expected[i]) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        this.describe(this.expected, description);
    }

    private void describe(byte[] bytes, Description description) {
        description.appendText("byte[] { ");
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            description.appendText(String.format("%02X ", b));
        }
        description.appendText("}");
    }
}

