/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCacheTest;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.RecordingPageCacheTracer;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheFixture;
import org.neo4j.io.pagecache.tracing.DelegatingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class MuninnPageCacheTest
extends PageCacheTest<MuninnPageCache> {
    private final long x = -3819410105021120785L;
    private final long y = -2392823106362282833L;
    private MuninnPageCacheFixture fixture;

    @Override
    protected PageCacheTestSupport.Fixture<MuninnPageCache> createFixture() {
        this.fixture = new MuninnPageCacheFixture();
        return this.fixture;
    }

    private PageCacheTracer blockCacheFlush(PageCacheTracer delegate) {
        this.fixture.backgroundFlushLatch = new CountDownLatch(1);
        return new DelegatingPageCacheTracer(delegate){

            @Override
            public MajorFlushEvent beginCacheFlush() {
                try {
                    ((MuninnPageCacheTest)MuninnPageCacheTest.this).fixture.backgroundFlushLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return super.beginCacheFlush();
            }
        };
    }

    @Test
    public void mustEvictCleanPageWithoutFlushing() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, 8, this.blockCacheFlush(tracer));
        PagedFile pagedFile = pageCache.map(this.file("a"), 8, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            Assert.assertTrue((boolean)cursor.next());
        }
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Fault.class));
        int clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
        Assert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1));
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
    }

    private void writeInitialDataTo(File file) throws IOException {
        StoreChannel channel = this.fs.create(file);
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(-3819410105021120785L);
        buf.putLong(-2392823106362282833L);
        buf.flip();
        channel.writeAll(buf);
        channel.close();
    }

    @Test
    public void mustFlushDirtyPagesOnEvictingFirstPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, 8, this.blockCacheFlush(tracer));
        PagedFile pagedFile = pageCache.map(this.file("a"), 8, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            cursor.putLong(0L);
        }
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Fault.class));
        int clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
        Assert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1));
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        ByteBuffer buf = ByteBuffer.allocate(16);
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        channel.read(buf);
        buf.flip();
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)-2392823106362282833L));
    }

    @Test
    public void mustFlushDirtyPagesOnEvictingLastPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, 8, this.blockCacheFlush(tracer));
        PagedFile pagedFile = pageCache.map(this.file("a"), 8, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(1L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            cursor.putLong(0L);
        }
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Fault.class));
        int clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
        Assert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1));
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        ByteBuffer buf = ByteBuffer.allocate(16);
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        channel.read(buf);
        buf.flip();
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)-3819410105021120785L));
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void mustFlushDirtyPagesOnEvictingAllPages() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, 8, this.blockCacheFlush(tracer));
        PagedFile pagedFile = pageCache.map(this.file("a"), 8, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 6);){
            Assert.assertTrue((boolean)cursor.next());
            cursor.putLong(0L);
            Assert.assertTrue((boolean)cursor.next());
            cursor.putLong(0L);
            Assert.assertFalse((boolean)cursor.next());
        }
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Fault.class));
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Fault.class));
        int clockArm = pageCache.evictPages(2, 0, tracer.beginPageEvictions(2));
        Assert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)2));
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        Assert.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        ByteBuffer buf = ByteBuffer.allocate(16);
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        channel.read(buf);
        buf.flip();
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void closingTheCursorMustUnlockModifiedPage() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, 8, PageCacheTracer.NULL);
        PagedFile pagedFile = pageCache.map(this.file("a"), 8, new OpenOption[0]);
        Future<?> task = executor.submit(() -> {
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assert.assertTrue((boolean)cursor.next());
                cursor.putLong(41L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        task.get();
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assert.assertTrue((boolean)cursor.next());
            long value = cursor.getLong();
            cursor.setOffset(0);
            cursor.putLong(value + 1L);
        }
        int clockArm = pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
        Assert.assertThat((Object)clockArm, (Matcher)Matchers.is((Object)1));
        ByteBuffer buf = ByteBuffer.allocate(16);
        StoreChannel channel = this.fs.open(this.file("a"), "r");
        channel.read(buf);
        buf.flip();
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)42L));
        Assert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)-2392823106362282833L));
    }

    @Test(timeout=120000L)
    public void mustUnblockPageFaultersWhenEvictionGetsException() throws Exception {
        this.writeInitialDataTo(this.file("a"));
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            @Override
            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    @Override
                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        throw new IOException("uh-oh...");
                    }
                };
            }
        };
        MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(fs, 2, 8, PageCacheTracer.NULL);
        PagedFile pagedFile = pageCache.map(this.file("a"), 8, new OpenOption[0]);
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            for (int i = 0; i < 1000; ++i) {
                Assert.assertTrue((boolean)cursor.next());
            }
            Assert.fail((String)"Expected an exception at this point");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void mustThrowIfMappingFileWouldOverflowReferenceCount() throws Exception {
        int i;
        File file = this.file("a");
        this.writeInitialDataTo(file);
        MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 30, this.pageCachePageSize, PageCacheTracer.NULL);
        PagedFile pf = null;
        try {
            this.expectedException.expect(IllegalStateException.class);
            for (i = 0; i < Integer.MAX_VALUE; ++i) {
                pf = pageCache.map(file, this.filePageSize, new OpenOption[0]);
            }
        }
        finally {
            for (int j = 0; j < i; ++j) {
                try {
                    pf.close();
                    continue;
                }
                catch (Exception e) {
                    throw new AssertionError("Did not expect pf.close() to throw", e);
                }
            }
        }
    }
}

