/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;

public class EphemeralFileSystemAbstractionCrashTest {
    private EphemeralFileSystemAbstraction fs;

    @Before
    public void setUp() {
        this.fs = new EphemeralFileSystemAbstraction();
    }

    @Test
    public void allowStoreThatExceedPredefinedSizes() throws IOException {
        File aFile = new File("test");
        StoreChannel channel = this.fs.open(aFile, "rw");
        ByteBuffer buffer = ByteBuffer.allocateDirect(8);
        int mebiBytes = (int)ByteUnit.mebiBytes((long)1L);
        for (int position = mebiBytes + 42; position < 10000000; position += mebiBytes) {
            buffer.putLong(1L);
            buffer.flip();
            channel.write(buffer, (long)position);
            buffer.clear();
        }
        channel.close();
    }

    @Test
    public void shouldNotLoseDataForcedBeforeFileSystemCrashes() throws Exception {
        int numberOfBytesForced = 8;
        File aFile = new File("yo");
        StoreChannel channel = this.fs.open(aFile, "rw");
        this.writeLong(channel, 1111L);
        channel.force(true);
        this.writeLong(channel, 2222L);
        this.fs.crash();
        StoreChannel readChannel = this.fs.open(aFile, "r");
        Assert.assertEquals((long)numberOfBytesForced, (long)readChannel.size());
        Assert.assertEquals((long)1111L, (long)this.readLong(readChannel).getLong());
    }

    @Test
    public void shouldBeConsistentAfterConcurrentWritesAndCrashes() throws Exception {
        File aFile = new File("contendedFile");
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int attempt = 0; attempt < 100; ++attempt) {
            ArrayList<Callable<Void>> workers = new ArrayList<Callable<Void>>();
            for (int i = 0; i < 100; ++i) {
                workers.add(() -> {
                    try {
                        StoreChannel channel = this.fs.open(aFile, "rw");
                        channel.position(0L);
                        this.writeLong(channel, 1L);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                });
                workers.add(() -> {
                    this.fs.crash();
                    return null;
                });
            }
            List futures = executorService.invokeAll(workers);
            for (Future future : futures) {
                future.get();
            }
            this.verifyFileIsEitherEmptyOrContainsLongIntegerValueOne(this.fs.open(aFile, "rw"));
        }
        executorService.shutdown();
    }

    @Test
    public void shouldBeConsistentAfterConcurrentWritesAndForces() throws Exception {
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int attempt = 0; attempt < 100; ++attempt) {
            EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
            File aFile = new File("contendedFile");
            ArrayList<Callable<Void>> workers = new ArrayList<Callable<Void>>();
            for (int i = 0; i < 100; ++i) {
                workers.add(() -> {
                    try {
                        StoreChannel channel = fs.open(aFile, "rw");
                        channel.position(channel.size());
                        this.writeLong(channel, 1L);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                });
                workers.add(() -> {
                    StoreChannel channel = fs.open(aFile, "rw");
                    channel.force(true);
                    return null;
                });
            }
            List futures = executorService.invokeAll(workers);
            for (Future future : futures) {
                future.get();
            }
            fs.crash();
            this.verifyFileIsFullOfLongIntegerOnes(fs.open(aFile, "rw"));
        }
        executorService.shutdown();
    }

    private void verifyFileIsFullOfLongIntegerOnes(StoreChannel channel) {
        try {
            long claimedSize = channel.size();
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)claimedSize);
            channel.read(buffer, 0L);
            buffer.flip();
            int position = 0;
            while ((long)position < claimedSize) {
                long value = buffer.getLong(position);
                Assert.assertEquals((long)1L, (long)value);
                position += 8;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyFileIsEitherEmptyOrContainsLongIntegerValueOne(StoreChannel channel) {
        try {
            long claimedSize = channel.size();
            ByteBuffer buffer = ByteBuffer.allocateDirect(8);
            channel.read(buffer, 0L);
            buffer.flip();
            if (claimedSize == 8L) {
                Assert.assertEquals((long)1L, (long)buffer.getLong());
            } else {
                try {
                    buffer.getLong();
                    Assert.fail((String)"Should have thrown an exception");
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ByteBuffer readLong(StoreChannel readChannel) throws IOException {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(8);
        readChannel.read(readBuffer);
        readBuffer.flip();
        return readBuffer;
    }

    private void writeLong(StoreChannel channel, long value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(8);
        buffer.putLong(value);
        buffer.flip();
        channel.write(buffer);
    }
}

