/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.io.IOException;
import java.util.Collection;

public final class IOUtils {
    private IOUtils() {
    }

    public static <T extends AutoCloseable> void closeAll(Collection<T> closeables) throws IOException {
        IOUtils.closeAll((AutoCloseable[])closeables.toArray(new AutoCloseable[closeables.size()]));
    }

    public static <T extends AutoCloseable> void closeAllSilently(Collection<T> closeables) {
        try {
            IOUtils.closeAll(closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAll(T ... closeables) throws IOException {
        Exception closeException = null;
        for (T closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (closeException == null) {
                    closeException = e;
                    continue;
                }
                closeException.addSuppressed(e);
            }
        }
        if (closeException != null) {
            throw new IOException("Exception closing multiple resources", closeException);
        }
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAllSilently(T ... closeables) {
        try {
            IOUtils.closeAll(closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

