/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.pagecache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import org.neo4j.adversaries.Adversary;
import org.neo4j.io.pagecache.PageCursor;

class AdversarialWritePageCursor
extends PageCursor {
    private final PageCursor delegate;
    private final Adversary adversary;
    private AdversarialWritePageCursor linkedCursor;

    AdversarialWritePageCursor(PageCursor delegate, Adversary adversary) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adversary = Objects.requireNonNull(adversary);
    }

    public byte getByte() {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getByte();
    }

    public byte getByte(int offset) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getByte(offset);
    }

    public void putByte(byte value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putByte(value);
    }

    public void putByte(int offset, byte value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putByte(offset, value);
    }

    public long getLong() {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getLong();
    }

    public long getLong(int offset) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getLong(offset);
    }

    public void putLong(long value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putLong(value);
    }

    public void putLong(int offset, long value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putLong(offset, value);
    }

    public int getInt() {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getInt();
    }

    public int getInt(int offset) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getInt(offset);
    }

    public void putInt(int value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putInt(value);
    }

    public void putInt(int offset, int value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putInt(offset, value);
    }

    public void getBytes(byte[] data) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.getBytes(data);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.getBytes(data, arrayOffset, length);
    }

    public void putBytes(byte[] data) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putBytes(data);
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putBytes(data, arrayOffset, length);
    }

    public short getShort() {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getShort();
    }

    public short getShort(int offset) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.getShort(offset);
    }

    public void putShort(short value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putShort(value);
    }

    public void putShort(int offset, short value) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.putShort(offset, value);
    }

    public void setOffset(int offset) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        this.delegate.setOffset(offset);
    }

    public int getOffset() {
        return this.delegate.getOffset();
    }

    public long getCurrentPageId() {
        return this.delegate.getCurrentPageId();
    }

    public int getCurrentPageSize() {
        return this.delegate.getCurrentPageSize();
    }

    public File getCurrentFile() {
        return this.delegate.getCurrentFile();
    }

    public void rewind() {
        this.delegate.rewind();
    }

    public boolean next() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        return this.delegate.next();
    }

    public boolean next(long pageId) throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        return this.delegate.next(pageId);
    }

    public void close() {
        this.delegate.close();
        this.linkedCursor = null;
    }

    public boolean shouldRetry() throws IOException {
        this.adversary.injectFailure(FileNotFoundException.class, IOException.class, SecurityException.class, IllegalStateException.class);
        boolean retry = this.delegate.shouldRetry();
        return retry || this.linkedCursor != null && this.linkedCursor.shouldRetry();
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        this.adversary.injectFailure(IndexOutOfBoundsException.class);
        return this.delegate.copyTo(sourceOffset, targetCursor, targetOffset, lengthInBytes);
    }

    public boolean checkAndClearBoundsFlag() {
        return this.delegate.checkAndClearBoundsFlag() || this.linkedCursor != null && this.linkedCursor.checkAndClearBoundsFlag();
    }

    public void raiseOutOfBounds() {
        this.delegate.raiseOutOfBounds();
    }

    public PageCursor openLinkedCursor(long pageId) {
        this.linkedCursor = new AdversarialWritePageCursor(this.delegate.openLinkedCursor(pageId), this.adversary);
        return this.linkedCursor;
    }
}

