/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.StackTraceElementGuardedAdversary;

public class ClassGuardedAdversary
extends StackTraceElementGuardedAdversary {
    public ClassGuardedAdversary(Adversary delegate, final Class<?> ... victimClassSet) {
        super(delegate, new Predicate<StackTraceElement>(){
            private final Set<String> victimClasses;
            {
                this.victimClasses = Stream.of(victimClassSet).map(Class::getName).collect(Collectors.toSet());
            }

            @Override
            public boolean test(StackTraceElement stackTraceElement) {
                return this.victimClasses.contains(stackTraceElement.getClassName());
            }
        });
    }
}

