/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public class DelegatingFileSystemAbstraction
implements FileSystemAbstraction {
    private final FileSystemAbstraction delegate;

    public DelegatingFileSystemAbstraction(FileSystemAbstraction delegate) {
        this.delegate = delegate;
    }

    @Override
    public FileWatcher fileWatcher() throws IOException {
        return this.delegate.fileWatcher();
    }

    @Override
    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        return this.delegate.open(fileName, options);
    }

    @Override
    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        this.delegate.moveToDirectory(file, toDirectory);
    }

    @Override
    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        this.delegate.copyToDirectory(file, toDirectory);
    }

    @Override
    public void mkdir(Path fileName) throws IOException {
        this.delegate.mkdir(fileName);
    }

    @Override
    public void copyFile(Path from, Path to) throws IOException {
        this.delegate.copyFile(from, to);
    }

    @Override
    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.delegate.copyFile(from, to, copyOptions);
    }

    @Override
    public void truncate(Path path, long size) throws IOException {
        this.delegate.truncate(path, size);
    }

    @Override
    public long lastModifiedTime(Path file) throws IOException {
        return this.delegate.lastModifiedTime(file);
    }

    @Override
    public void deleteFileOrThrow(Path file) throws IOException {
        this.delegate.deleteFileOrThrow(file);
    }

    @Override
    public int getFileDescriptor(StoreChannel channel) {
        return this.delegate.getFileDescriptor(channel);
    }

    @Override
    public boolean isPersistent() {
        return this.delegate.isPersistent();
    }

    @Override
    public Path createTempFile(String prefix, String suffix) throws IOException {
        return this.delegate.createTempFile(prefix, suffix);
    }

    @Override
    public Path createTempFile(Path dir, String prefix, String suffix) throws IOException {
        return this.delegate.createTempFile(dir, prefix, suffix);
    }

    @Override
    public Path createTempDirectory(String prefix) throws IOException {
        return this.delegate.createTempDirectory(prefix);
    }

    @Override
    public Path createTempDirectory(Path dir, String prefix) throws IOException {
        return this.delegate.createTempDirectory(dir, prefix);
    }

    @Override
    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.delegate.renameFile(from, to, copyOptions);
    }

    @Override
    public StoreChannel read(Path fileName) throws IOException {
        return this.delegate.read(fileName);
    }

    @Override
    public StoreChannel write(Path fileName) throws IOException {
        return this.delegate.write(fileName);
    }

    @Override
    public void mkdirs(Path fileName) throws IOException {
        this.delegate.mkdirs(fileName);
    }

    @Override
    public void deleteFile(Path fileName) throws IOException {
        this.delegate.deleteFile(fileName);
    }

    @Override
    public InputStream openAsInputStream(Path fileName) throws IOException {
        return this.delegate.openAsInputStream(fileName);
    }

    @Override
    public boolean fileExists(Path file) {
        return this.delegate.fileExists(file);
    }

    @Override
    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) throws IOException {
        return this.delegate.listFiles(directory, filter);
    }

    @Override
    public boolean isDirectory(Path file) {
        return this.delegate.isDirectory(file);
    }

    @Override
    public long getFileSize(Path fileName) throws IOException {
        return this.delegate.getFileSize(fileName);
    }

    @Override
    public long getBlockSize(Path file) throws IOException {
        return this.delegate.getBlockSize(file);
    }

    @Override
    public Path[] listFiles(Path directory) throws IOException {
        return this.delegate.listFiles(directory);
    }

    @Override
    public void deleteRecursively(Path directory) throws IOException {
        this.delegate.deleteRecursively(directory);
    }

    @Override
    public void deleteRecursively(Path directory, Predicate<Path> removeFilePredicate) throws IOException {
        this.delegate.deleteRecursively(directory, removeFilePredicate);
    }

    @Override
    public OutputStream openAsOutputStream(Path fileName, boolean append, int bufferSize, boolean autoFlush) throws IOException {
        return this.delegate.openAsOutputStream(fileName, append, bufferSize, autoFlush);
    }

    @Override
    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        this.delegate.copyRecursively(fromDirectory, toDirectory);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

