/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.async;

import java.io.IOException;

public interface AsyncBlockAccessor
extends AutoCloseable {
    public static final AsyncBlockAccessor EMPTY_ASYNC_BLOCK_ACCESSOR = new EmptyAsyncBlockAccessor();

    public boolean isAvailable();

    public void asyncWrite(int var1, long var2, long var4, long var6, int var8) throws IOException;

    public void asyncRead(int var1, long var2, long var4, long var6, int var8) throws IOException;

    public void asyncVectorWrite(int var1, long var2, long[] var4, int[] var5) throws IOException;

    public void asyncVectorRead(int var1, long var2, long[] var4, int[] var5) throws IOException;

    public void completeSubmitted();

    @Override
    public void close();

    public static class EmptyAsyncBlockAccessor
    implements AsyncBlockAccessor {
        private EmptyAsyncBlockAccessor() {
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void asyncWrite(int fileDescriptor, long pageRef, long offset, long bufferAddress, int bufferSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void asyncRead(int fileDescriptor, long pageRef, long offset, long bufferAddress, int bufferSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void asyncVectorWrite(int fileDescriptor, long offset, long[] bufferAddress, int[] bufferSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void asyncVectorRead(int fileDescriptor, long offset, long[] bufferAddress, int[] bufferSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void completeSubmitted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }
}

