/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.memory.BufferLeakTracker;
import org.neo4j.memory.MemoryTracker;

public final class ByteBuffers {
    public static final BufferLeakTracker BUFFER_LEAK_TRACKER = Boolean.getBoolean("org.neo4j.ByteBuffers.TRACK_BUFFERS") ? BufferLeakTracker.ENABLED_TRACKER : BufferLeakTracker.DISABLED_TRACKER;

    private ByteBuffers() {
    }

    public static ByteBuffer allocate(int capacity, ByteOrder order, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap((long)capacity);
        try {
            return ByteBuffer.allocate(capacity).order(order);
        }
        catch (Throwable any) {
            memoryTracker.releaseHeap((long)capacity);
            throw any;
        }
    }

    public static ByteBuffer allocateDirect(int capacity, ByteOrder order, MemoryTracker memoryTracker) {
        if (UnsafeUtil.unsafeByteBufferAccessAvailable()) {
            return BUFFER_LEAK_TRACKER.track(UnsafeUtil.allocateByteBuffer((int)capacity, (MemoryTracker)memoryTracker).order(order));
        }
        return BUFFER_LEAK_TRACKER.track(ByteBuffers.allocateDirectFallback(capacity, memoryTracker).order(order));
    }

    public static void releaseBuffer(ByteBuffer byteBuffer, MemoryTracker memoryTracker) {
        BUFFER_LEAK_TRACKER.release(byteBuffer);
        if (UnsafeUtil.unsafeByteBufferAccessAvailable()) {
            UnsafeUtil.releaseBuffer((ByteBuffer)byteBuffer, (MemoryTracker)memoryTracker);
        } else {
            ByteBuffers.releaseBufferFallback(byteBuffer, memoryTracker);
        }
    }

    private static ByteBuffer allocateDirectFallback(int capacity, MemoryTracker memoryTracker) {
        memoryTracker.allocateNative((long)capacity);
        try {
            return ByteBuffer.allocateDirect(capacity);
        }
        catch (Throwable any) {
            memoryTracker.releaseNative((long)capacity);
            throw any;
        }
    }

    private static void releaseBufferFallback(ByteBuffer byteBuffer, MemoryTracker memoryTracker) {
        if (!byteBuffer.isDirect()) {
            memoryTracker.releaseHeap((long)byteBuffer.capacity());
            return;
        }
        int capacity = byteBuffer.capacity();
        UnsafeUtil.invokeCleaner((ByteBuffer)byteBuffer);
        memoryTracker.releaseNative((long)capacity);
    }
}

