/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class HeapScopedBufferTest {
    HeapScopedBufferTest() {
    }

    @Test
    void trackBufferScopeMemoryAllocation() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 400L, 0L, null);
        try (HeapScopedBuffer bufferScope = new HeapScopedBuffer(100, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)memoryTracker);){
            Assertions.assertEquals((long)100L, (long)memoryTracker.estimatedHeapMemory());
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        }
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void closeBufferMultipleTimesIsSafe() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 400L, 0L, null);
        HeapScopedBuffer bufferScope = new HeapScopedBuffer(100, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)memoryTracker);
        Assertions.assertEquals((long)100L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        bufferScope.close();
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        bufferScope.close();
        bufferScope.close();
        bufferScope.close();
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }
}

