/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.common.DependencyResolver;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.index.internal.gbptree.CleanTrackingConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.DataTree;
import org.neo4j.index.internal.gbptree.DataTreeAlreadyExistsException;
import org.neo4j.index.internal.gbptree.DataTreeNotFoundException;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyChecker;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.LongSpinLatch;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.PrintConfig;
import org.neo4j.index.internal.gbptree.PrintingGBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootLayer;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.index.internal.gbptree.RootMappingLayout;
import org.neo4j.index.internal.gbptree.SeekCursor;
import org.neo4j.index.internal.gbptree.SeekDepthMonitor;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.TrackingValueMerger;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNodeLatchService;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.TreeRootExchange;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.ValueMergers;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.Futures;

class MultiRootLayer<ROOT_KEY, DATA_KEY, DATA_VALUE>
extends RootLayer<ROOT_KEY, DATA_KEY, DATA_VALUE> {
    private static final int BYTE_SIZE_PER_CACHED_EXTERNAL_ROOT = 48;
    private final Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout;
    private final LeafNodeBehaviour<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLeafNode;
    private final InternalNodeBehaviour<ROOT_KEY> rootInternalNode;
    private final AtomicReferenceArray<DataTreeRoot<ROOT_KEY>> rootMappingCache;
    private final TreeNodeLatchService rootMappingCacheLatches = new TreeNodeLatchService();
    private final ValueMerger<ROOT_KEY, RootMappingLayout.RootMappingValue> DONT_ALLOW_CREATE_EXISTING_ROOT = (existingKey, newKey, existingValue, newValue) -> {
        throw new DataTreeAlreadyExistsException(existingKey);
    };
    private final Layout<DATA_KEY, DATA_VALUE> dataLayout;
    private final LeafNodeBehaviour<DATA_KEY, DATA_VALUE> dataLeafNode;
    private final InternalNodeBehaviour<DATA_KEY> dataInternalNode;

    MultiRootLayer(RootLayerSupport support, Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout, Layout<DATA_KEY, DATA_VALUE> dataLayout, int rootCacheSizeInBytes, TreeNodeSelector treeNodeSelector, DependencyResolver dependencyResolver) {
        super(support, treeNodeSelector);
        Preconditions.checkState((boolean)this.hashCodeSeemsImplemented(rootLayout), (String)"Root layout doesn't seem to have a hashCode() implementation");
        this.rootLayout = rootLayout;
        this.dataLayout = dataLayout;
        int numCachedRoots = rootCacheSizeInBytes / 48;
        this.rootMappingCache = new AtomicReferenceArray(Integer.max(numCachedRoots, 10));
        TreeNodeSelector.Factory rootMappingFormat = treeNodeSelector.selectByLayout(this.rootLayout);
        TreeNodeSelector.Factory format = treeNodeSelector.selectByLayout(dataLayout);
        OffloadStoreImpl<ROOT_KEY, RootMappingLayout.RootMappingValue> rootOffloadStore = support.buildOffload(this.rootLayout);
        OffloadStoreImpl<DATA_KEY, DATA_VALUE> dataOffloadStore = support.buildOffload(dataLayout);
        this.rootLeafNode = rootMappingFormat.createLeafBehaviour(support.payloadSize(), this.rootLayout, rootOffloadStore, dependencyResolver);
        this.rootInternalNode = rootMappingFormat.createInternalBehaviour(support.payloadSize(), this.rootLayout, rootOffloadStore, dependencyResolver);
        this.dataLeafNode = format.createLeafBehaviour(support.payloadSize(), dataLayout, dataOffloadStore, dependencyResolver);
        this.dataInternalNode = format.createInternalBehaviour(support.payloadSize(), dataLayout, dataOffloadStore, dependencyResolver);
    }

    private boolean hashCodeSeemsImplemented(Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout) {
        Object key1 = rootLayout.newKey();
        Object key2 = rootLayout.newKey();
        rootLayout.initializeAsHighest(key1);
        rootLayout.initializeAsHighest(key2);
        return key1.hashCode() == key2.hashCode();
    }

    @Override
    void initializeAfterCreation(Root firstRoot, CursorContext cursorContext) throws IOException {
        this.setRoot(firstRoot, cursorContext);
        this.support.writeMeta(this.rootLayout, this.dataLayout, cursorContext, this.treeNodeSelector);
        this.support.initializeNewRoot(this.root, this.rootLeafNode, (byte)1, cursorContext);
    }

    @Override
    void initialize(Root root, CursorContext cursorContext) throws IOException {
        this.setRoot(root, cursorContext);
        this.support.readMeta(cursorContext).verify(this.dataLayout, this.rootLayout, this.treeNodeSelector);
    }

    @Override
    void create(ROOT_KEY dataRootKey, CursorContext cursorContext) throws IOException {
        CursorCreator cursorCreator = CursorCreator.bind(this.support, 2, cursorContext);
        try (Writer<ROOT_KEY, RootMappingLayout.RootMappingValue> rootMappingWriter = this.support.internalParallelWriter(this.rootLayout, this.rootLeafNode, this.rootInternalNode, 0.5, cursorContext, this, (byte)1);){
            dataRootKey = this.rootLayout.copyKey(dataRootKey);
            long generation = this.support.generation();
            long stableGeneration = Generation.stableGeneration(generation);
            long unstableGeneration = Generation.unstableGeneration(generation);
            long rootId = this.support.idProvider().acquireNewId(stableGeneration, unstableGeneration, cursorCreator);
            try {
                Root dataRoot = new Root(rootId, unstableGeneration);
                this.support.initializeNewRoot(dataRoot, this.dataLeafNode, (byte)0, cursorContext);
                rootMappingWriter.merge(dataRootKey, new RootMappingLayout.RootMappingValue().initialize(dataRoot), this.DONT_ALLOW_CREATE_EXISTING_ROOT);
                this.cache(new DataTreeRoot<ROOT_KEY>(dataRootKey, dataRoot));
            }
            catch (DataTreeAlreadyExistsException e) {
                this.support.idProvider().releaseId(stableGeneration, unstableGeneration, rootId, cursorCreator);
                throw e;
            }
        }
    }

    @Override
    void delete(ROOT_KEY dataRootKey, CursorContext cursorContext) throws IOException {
        int cacheIndex = this.cacheIndex(dataRootKey);
        try (Writer<ROOT_KEY, RootMappingLayout.RootMappingValue> rootMappingWriter = this.support.internalParallelWriter(this.rootLayout, this.rootLeafNode, this.rootInternalNode, 0.5, cursorContext, this, (byte)1);){
            MutableLong rootIdToRelease;
            do {
                rootIdToRelease = new MutableLong();
                ValueMerger<Object, RootMappingLayout.RootMappingValue> rootMappingMerger = (existingKey, newKey, existingValue, newValue) -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                };
                rootMappingWriter.mergeIfExists(dataRootKey, new RootMappingLayout.RootMappingValue().initialize(new Root(-1L, -1L)), rootMappingMerger);
                if (rootIdToRelease.longValue() != 0L) continue;
                throw new DataTreeNotFoundException(dataRootKey);
            } while (rootIdToRelease.longValue() == -1L);
            long generation = this.support.generation();
            this.support.idProvider().releaseId(Generation.stableGeneration(generation), Generation.unstableGeneration(generation), rootIdToRelease.longValue(), CursorCreator.bind(this.support, 2, cursorContext));
        }
    }

    private static long cacheIndexAsTreeNodeId(int cacheIndex) {
        return ((long)cacheIndex & 0xFFFFFFFFL) + 1L;
    }

    @Override
    DataTree<DATA_KEY, DATA_VALUE> access(ROOT_KEY dataRootKey) {
        return new MultiDataTree(dataRootKey);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void visit(GBPTreeVisitor visitor, CursorContext cursorContext) throws IOException {
        long generation = this.support.generation();
        GBPTreeStructure<ROOT_KEY, DATA_KEY, DATA_VALUE> structure = new GBPTreeStructure<ROOT_KEY, DATA_KEY, DATA_VALUE>(this.rootLayout, this.rootLeafNode, this.rootInternalNode, this.dataLayout, this.dataLeafNode, this.dataInternalNode, Generation.stableGeneration(generation), Generation.unstableGeneration(generation));
        CursorCreator cursorCreator = CursorCreator.bind(this.support, 1, cursorContext);
        try (PageCursor cursor = this.support.openRootCursor(this.root, 1, cursorContext);){
            structure.visitTree(cursor, visitor, cursorContext);
            this.support.idProvider().visitFreelist(visitor, cursorCreator);
        }
        try (Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> allRootsSeek = this.allRootsSeek(cursorContext);){
            while (allRootsSeek.next()) {
                PageCursor cursor = this.support.openRootCursor(allRootsSeek.value().asRoot(), 1, cursorContext);
                try {
                    structure.visitTree(cursor, visitor, cursorContext);
                    this.support.idProvider().visitFreelist(visitor, cursorCreator);
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            return;
        }
    }

    @Override
    void consistencyCheck(GBPTreeConsistencyChecker.ConsistencyCheckState state, GBPTreeConsistencyCheckVisitor visitor, boolean reportDirty, CursorContextFactory contextFactory, int numThreads) throws IOException {
        long generation = this.support.generation();
        long stableGeneration = Generation.stableGeneration(generation);
        long unstableGeneration = Generation.unstableGeneration(generation);
        PagedFile pagedFile = this.support.pagedFile();
        CleanTrackingConsistencyCheckVisitor isRootTreeClean = new CleanTrackingConsistencyCheckVisitor(visitor);
        LongAdder dataRootCount = new LongAdder();
        new GBPTreeConsistencyChecker<ROOT_KEY>(this.rootLeafNode, this.rootInternalNode, this.rootLayout, state, numThreads, stableGeneration, unstableGeneration, reportDirty, pagedFile.path(), (ThrowingFunction<CursorContext, PageCursor, IOException>)((ThrowingFunction)ctx -> pagedFile.io(0L, 1, ctx)), this.root, contextFactory).check(isRootTreeClean, state.progress, dataRootCount::add);
        if (!isRootTreeClean.isConsistent()) {
            return;
        }
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        int batchSize = 100;
        double batchSizeSwitchThreshold = (double)dataRootCount.sum() * 0.9;
        try (CursorContext context = contextFactory.create("allRootsSeek");){
            ArrayList<Root> dataTreeRootBatch = new ArrayList<Root>();
            try (Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> rootSeeker = this.allRootsSeek(context);){
                int numBatchesAdded = 0;
                long numRootsSeen = 0L;
                while (rootSeeker.next()) {
                    dataTreeRootBatch.add(rootSeeker.value().asRoot());
                    if (dataTreeRootBatch.size() == batchSize) {
                        futures.add(this.submitDataTreeRootBatch(dataTreeRootBatch, state, stableGeneration, unstableGeneration, reportDirty, pagedFile, visitor, contextFactory));
                        if (++numBatchesAdded % 100 == 0) {
                            while (!futures.isEmpty() && ((Future)futures.peekFirst()).isDone()) {
                                ((Future)futures.removeFirst()).get();
                            }
                        }
                        if (batchSize > 1 && (double)numRootsSeen >= batchSizeSwitchThreshold) {
                            batchSize = 1;
                        }
                    }
                    ++numRootsSeen;
                }
                if (!dataTreeRootBatch.isEmpty()) {
                    futures.add(this.submitDataTreeRootBatch(dataTreeRootBatch, state, stableGeneration, unstableGeneration, reportDirty, pagedFile, visitor, contextFactory));
                }
            }
            Futures.getAll(futures);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private Future<Void> submitDataTreeRootBatch(List<Root> dataTreeRootBatch, GBPTreeConsistencyChecker.ConsistencyCheckState state, long stableGeneration, long unstableGeneration, boolean reportDirty, PagedFile pagedFile, GBPTreeConsistencyCheckVisitor visitor, CursorContextFactory contextFactory) {
        Root[] batch = dataTreeRootBatch.toArray(new Root[0]);
        dataTreeRootBatch.clear();
        return state.executor.submit(() -> {
            Object low = this.dataLayout.newKey();
            Object high = this.dataLayout.newKey();
            this.dataLayout.initializeAsLowest(low);
            this.dataLayout.initializeAsHighest(high);
            try (ProgressListener partitionProgress = state.progress.threadLocalReporter();){
                for (Root root : batch) {
                    new GBPTreeConsistencyChecker<DATA_KEY>(this.dataLeafNode, this.dataInternalNode, this.dataLayout, state, 1, stableGeneration, unstableGeneration, reportDirty, pagedFile.path(), (ThrowingFunction<CursorContext, PageCursor, IOException>)((ThrowingFunction)ctx -> pagedFile.io(0L, 1, ctx)), root, contextFactory).check(visitor, partitionProgress, GBPTreeConsistencyChecker.NO_MONITOR);
                }
            }
            return null;
        });
    }

    private int depthOf(Root root, SeekCursor<DATA_KEY, DATA_VALUE> seeker, DATA_KEY low, DATA_KEY high) throws IOException {
        try {
            SeekDepthMonitor depthMonitor = new SeekDepthMonitor();
            this.support.initializeSeeker(seeker, c -> root, low, high, 1, Integer.MAX_VALUE, depthMonitor);
            return depthMonitor.treeDepth;
        }
        catch (TreeInconsistencyException e) {
            return -1;
        }
    }

    private Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> allRootsSeek(CursorContext cursorContext) throws IOException {
        Object low = this.rootLayout.newKey();
        Object high = this.rootLayout.newKey();
        this.rootLayout.initializeAsLowest(low);
        this.rootLayout.initializeAsHighest(high);
        return this.support.initializeSeeker(this.support.internalAllocateSeeker(this.rootLayout, cursorContext, this.rootLeafNode, this.rootInternalNode), this, low, high, 20, Integer.MAX_VALUE, SeekCursor.NO_MONITOR);
    }

    @Override
    int keyValueSizeCap() {
        return this.dataLeafNode.keyValueSizeCap();
    }

    @Override
    int inlineKeyValueSizeCap() {
        return this.dataLeafNode.inlineKeyValueSizeCap();
    }

    @Override
    void unsafe(GBPTreeUnsafe unsafe, boolean dataTree, CursorContext cursorContext) throws IOException {
        if (dataTree) {
            this.support.unsafe(unsafe, this.dataLayout, this.dataLeafNode, this.dataInternalNode, cursorContext);
        } else {
            this.support.unsafe(unsafe, this.rootLayout, this.rootLeafNode, this.rootInternalNode, cursorContext);
        }
    }

    @Override
    CrashGenerationCleaner createCrashGenerationCleaner(CursorContextFactory contextFactory) {
        return this.support.createCrashGenerationCleaner(this.rootInternalNode, this.dataInternalNode, contextFactory);
    }

    @Override
    void printNode(PageCursor cursor, CursorContext cursorContext) {
        try {
            boolean isDataNode;
            long generation = this.support.generation();
            long stableGeneration = Generation.stableGeneration(generation);
            long unstableGeneration = Generation.unstableGeneration(generation);
            boolean bl = isDataNode = TreeNodeUtil.layerType(cursor) == 0;
            if (isDataNode) {
                new GBPTreeStructure(null, null, null, this.dataLayout, this.dataLeafNode, this.dataInternalNode, stableGeneration, unstableGeneration).visitTreeNode(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults()), cursorContext);
            } else {
                new GBPTreeStructure(this.rootLayout, this.rootLeafNode, this.rootInternalNode, null, null, null, stableGeneration, unstableGeneration).visitTreeNode(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults()), cursorContext);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void cache(DataTreeRoot<ROOT_KEY> dataRoot) {
        this.rootMappingCache.set(this.cacheIndex(dataRoot.key), dataRoot);
    }

    private int cacheIndex(ROOT_KEY dataRootKey) {
        int hashCode = dataRootKey.hashCode();
        return hashCode == Integer.MIN_VALUE ? 0 : Math.abs(hashCode) % this.rootMappingCache.length();
    }

    @Override
    void visitAllDataTreeRoots(CursorContext cursorContext, RootLayer.TreeRootsVisitor<ROOT_KEY> visitor) throws IOException {
        try (Seeker<ROOT_KEY, RootMappingLayout.RootMappingValue> seek = this.allRootsSeek(cursorContext);){
            while (seek.next() && !visitor.accept(this.rootLayout.copyKey(seek.key()))) {
            }
        }
    }

    private record DataTreeRoot<DATA_ROOT_KEY>(DATA_ROOT_KEY key, Root root) {
    }

    private class MultiDataTree
    implements DataTree<DATA_KEY, DATA_VALUE> {
        private final RootMappingInteraction rootMappingInteraction;

        MultiDataTree(ROOT_KEY dataRootKey) {
            this.rootMappingInteraction = new RootMappingInteraction(dataRootKey);
        }

        @Override
        public Writer<DATA_KEY, DATA_VALUE> writer(int flags, CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.internalParallelWriter(MultiRootLayer.this.dataLayout, MultiRootLayer.this.dataLeafNode, MultiRootLayer.this.dataInternalNode, RootLayer.splitRatio(flags), cursorContext, this.rootMappingInteraction, (byte)0);
        }

        @Override
        public Seeker<DATA_KEY, DATA_VALUE> allocateSeeker(CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.internalAllocateSeeker(MultiRootLayer.this.dataLayout, cursorContext, MultiRootLayer.this.dataLeafNode, MultiRootLayer.this.dataInternalNode);
        }

        @Override
        public Seeker<DATA_KEY, DATA_VALUE> seek(Seeker<DATA_KEY, DATA_VALUE> seeker, DATA_KEY fromInclusive, DATA_KEY toExclusive) throws IOException {
            return MultiRootLayer.this.support.initializeSeeker(seeker, this.rootMappingInteraction, fromInclusive, toExclusive, 20, Integer.MAX_VALUE, SeekCursor.NO_MONITOR);
        }

        @Override
        public List<DATA_KEY> partitionedSeek(DATA_KEY fromInclusive, DATA_KEY toExclusive, int numberOfPartitions, CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.internalPartitionedSeek(MultiRootLayer.this.dataLayout, MultiRootLayer.this.dataLeafNode, MultiRootLayer.this.dataInternalNode, fromInclusive, toExclusive, numberOfPartitions, this.rootMappingInteraction, cursorContext);
        }

        @Override
        public long estimateNumberOfEntriesInTree(CursorContext cursorContext) throws IOException {
            return MultiRootLayer.this.support.estimateNumberOfEntriesInTree(MultiRootLayer.this.dataLayout, MultiRootLayer.this.dataLeafNode, MultiRootLayer.this.dataInternalNode, this.rootMappingInteraction, cursorContext);
        }
    }

    private class RootMappingInteraction
    implements TreeRootExchange {
        private final ROOT_KEY dataRootKey;
        private final int cacheIndex;

        RootMappingInteraction(ROOT_KEY dataRootKey) {
            this.dataRootKey = dataRootKey;
            this.cacheIndex = MultiRootLayer.this.cacheIndex(dataRootKey);
        }

        /*
         * Loose catch block
         */
        @Override
        public Root getRoot(CursorContext context) {
            DataTreeRoot dataRoot = MultiRootLayer.this.rootMappingCache.get(this.cacheIndex);
            if (dataRoot != null && MultiRootLayer.this.rootLayout.compare(dataRoot.key, this.dataRootKey) == 0) {
                return dataRoot.root;
            }
            LongSpinLatch rootMappingLatch = MultiRootLayer.this.rootMappingCacheLatches.latch(MultiRootLayer.cacheIndexAsTreeNodeId(this.cacheIndex));
            rootMappingLatch.acquireRead();
            try {
                block13: {
                    Root root;
                    block14: {
                        Seeker seek = MultiRootLayer.this.support.initializeSeeker(MultiRootLayer.this.support.internalAllocateSeeker(MultiRootLayer.this.rootLayout, context, MultiRootLayer.this.rootLeafNode, MultiRootLayer.this.rootInternalNode), c -> MultiRootLayer.this.root, this.dataRootKey, this.dataRootKey, 20, Integer.MAX_VALUE, SeekCursor.NO_MONITOR);
                        if (!seek.next()) break block13;
                        Root root2 = seek.value().asRoot();
                        this.cacheReadRoot(root2);
                        root = root2;
                        if (seek == null) break block14;
                        {
                            catch (Throwable throwable) {
                                if (seek != null) {
                                    try {
                                        seek.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        seek.close();
                    }
                    return root;
                }
                try {
                    throw new DataTreeNotFoundException(this.dataRootKey);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                rootMappingLatch.releaseRead();
                rootMappingLatch.deref();
            }
        }

        private void cacheReadRoot(Root root) {
            DataTreeRoot from;
            DataTreeRoot to = new DataTreeRoot(this.dataRootKey, root);
            while (!((from = MultiRootLayer.this.rootMappingCache.get(this.cacheIndex)) != null && MultiRootLayer.this.rootLayout.compare(from.key, this.dataRootKey) == 0 || MultiRootLayer.this.rootMappingCache.compareAndSet(this.cacheIndex, from, to))) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRoot(Root newRoot, CursorContext context) throws IOException {
            LongSpinLatch rootMappingLatch = MultiRootLayer.this.rootMappingCacheLatches.latch(MultiRootLayer.cacheIndexAsTreeNodeId(this.cacheIndex));
            rootMappingLatch.acquireWrite();
            try (Writer rootMappingWriter = MultiRootLayer.this.support.internalParallelWriter(MultiRootLayer.this.rootLayout, MultiRootLayer.this.rootLeafNode, MultiRootLayer.this.rootInternalNode, 0.5, context, MultiRootLayer.this, (byte)0);){
                MultiRootLayer.this.cache(new DataTreeRoot(this.dataRootKey, newRoot));
                TrackingValueMerger merger = new TrackingValueMerger(ValueMergers.overwrite());
                rootMappingWriter.mergeIfExists(this.dataRootKey, new RootMappingLayout.RootMappingValue().initialize(newRoot), merger);
                if (!merger.wasMerged()) {
                    throw new DataTreeNotFoundException(this.dataRootKey);
                }
            }
            finally {
                rootMappingLatch.releaseWrite();
                rootMappingLatch.deref();
            }
        }
    }
}

