/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.concurrent.TimeUnit;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.batchimport.staging.StageExecution;

public interface ExecutionMonitor {
    public static final ExecutionMonitor INVISIBLE = new ExecutionMonitor(){

        @Override
        public void start(StageExecution execution) {
        }

        @Override
        public void end(StageExecution execution, long totalTimeMillis) {
        }

        @Override
        public long checkIntervalMillis() {
            return Long.MAX_VALUE;
        }

        @Override
        public void check(StageExecution execution) {
        }

        @Override
        public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        }
    };

    default public void initialize(DependencyResolver dependencyResolver) {
    }

    public void start(StageExecution var1);

    public void end(StageExecution var1, long var2);

    public void done(boolean var1, long var2, String var4);

    public long checkIntervalMillis();

    public void check(StageExecution var1);

    public static abstract class Adapter
    implements ExecutionMonitor {
        private final long intervalMillis;

        public Adapter(long time, TimeUnit unit) {
            this.intervalMillis = unit.toMillis(time);
        }

        @Override
        public long checkIntervalMillis() {
            return this.intervalMillis;
        }

        @Override
        public void start(StageExecution execution) {
        }

        @Override
        public void end(StageExecution execution, long totalTimeMillis) {
        }

        @Override
        public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        }
    }
}

