/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.string.CollisionValues;
import org.neo4j.memory.MemoryTracker;

public class LongCollisionValues
implements CollisionValues {
    private final LongArray cache;
    private final AtomicLong nextOffset = new AtomicLong();

    public LongCollisionValues(NumberArrayFactory factory, long length, MemoryTracker memoryTracker) {
        this.cache = factory.newLongArray(length, 0L, memoryTracker);
    }

    @Override
    public long add(Object id) {
        long collisionIndex = this.nextOffset.getAndIncrement();
        this.cache.set(collisionIndex, ((Number)id).longValue());
        return collisionIndex;
    }

    @Override
    public Object get(long offset) {
        return this.cache.get(offset);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

