/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.batchimport.IncrementalBatchImportUtil;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.batchimport.SchemaMonitor;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.UnsafeDirectByteBufferAllocator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class OtherAffectedSchemaMonitors
implements Supplier<SchemaMonitor>,
Closeable {
    private final FileSystemAbstraction fileSystem;
    private final IndexProviderMap indexProviderMap;
    private final IndexProviderMap tempIndexes;
    private final SchemaCache schemaCache;
    private final TokenNameLookup tokenNameLookup;
    private final EntityType entityType;
    private final ImmutableSet<OpenOption> openOptions;
    private final PopulationWorkJobScheduler workScheduler;
    private final LongToLongFunction indexedEntityIdConverter;
    private final LongToLongFunction entityIdFromIndexIdConverter;
    private final Configuration configuration;
    private final IndexStatisticsStore indexStatisticsStore;
    private final IntObjectMap<List<int[]>> propertyExistenceConstraints;
    private final Map<IndexDescriptor, IndexPopulator> indexPopulators = new ConcurrentHashMap<IndexDescriptor, IndexPopulator>();
    private final Lock populatorConstructionLock = new ReentrantLock();
    private final ByteBufferFactory bufferFactory;
    private final MutableLongSet violatingEntities = LongSets.mutable.empty().asSynchronized();
    private final StorageEngineIndexingBehaviour indexingBehaviour;
    private final boolean incrementalIndexing;

    public OtherAffectedSchemaMonitors(FileSystemAbstraction fileSystem, IndexProviderMap indexProviderMap, IndexProviderMap tempIndexes, SchemaCache schemaCache, TokenNameLookup tokenNameLookup, EntityType entityType, ImmutableSet<OpenOption> openOptions, PopulationWorkJobScheduler workScheduler, LongToLongFunction indexedEntityIdConverter, LongToLongFunction entityIdFromIndexIdConverter, Configuration configuration, IndexStatisticsStore indexStatisticsStore, StorageEngineIndexingBehaviour indexingBehaviour, boolean incrementalIndexing) {
        this.fileSystem = fileSystem;
        this.indexProviderMap = indexProviderMap;
        this.tempIndexes = tempIndexes;
        this.schemaCache = schemaCache;
        this.tokenNameLookup = tokenNameLookup;
        this.entityType = entityType;
        this.openOptions = openOptions;
        this.workScheduler = workScheduler;
        this.indexedEntityIdConverter = indexedEntityIdConverter;
        this.entityIdFromIndexIdConverter = entityIdFromIndexIdConverter;
        this.configuration = configuration;
        this.indexStatisticsStore = indexStatisticsStore;
        this.indexingBehaviour = indexingBehaviour;
        this.incrementalIndexing = incrementalIndexing;
        this.propertyExistenceConstraints = OtherAffectedSchemaMonitors.buildPropertyExistenceConstraintsMap(schemaCache, entityType);
        this.bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, ((Long)Config.defaults().get(GraphDatabaseInternalSettings.index_populator_block_size)).intValue());
    }

    private static MutableIntObjectMap<List<int[]>> buildPropertyExistenceConstraintsMap(SchemaCache schemaCache, EntityType entityType) {
        MutableIntObjectMap propertyExistenceConstraints = IntObjectMaps.mutable.empty();
        for (ConstraintDescriptor constraint : schemaCache.constraints()) {
            if (!constraint.enforcesPropertyExistence() || constraint.schema().entityType() != entityType) continue;
            SchemaDescriptor schema = constraint.schema();
            for (int entityToken : schema.getEntityTokenIds()) {
                ((List)propertyExistenceConstraints.getIfAbsentPut(entityToken, ArrayList::new)).add(schema.getPropertyIds());
            }
        }
        return propertyExistenceConstraints.isEmpty() ? null : propertyExistenceConstraints;
    }

    @Override
    public SchemaMonitor get() {
        return new OtherAffectedSchemaMonitor();
    }

    public void completeBuild(Collector collector, Consumer<Runnable> scheduler) {
        for (Map.Entry<IndexDescriptor, IndexPopulator> population : this.indexPopulators.entrySet()) {
            IndexPopulator populator = population.getValue();
            scheduler.accept(() -> {
                RecordingIndexEntryConflictHandler conflictHandler = new RecordingIndexEntryConflictHandler(collector, this.violatingEntities, (IndexDescriptor)population.getKey(), this.tokenNameLookup, this.entityIdFromIndexIdConverter);
                try {
                    populator.scanCompleted(PhaseTracker.nullInstance, (IndexPopulator.PopulationWorkScheduler)this.workScheduler, (IndexEntryConflictHandler)conflictHandler, CursorContext.NULL_CONTEXT);
                    this.indexStatisticsStore.setSampleStats(((IndexDescriptor)population.getKey()).getId(), populator.sample(CursorContext.NULL_CONTEXT));
                    populator.close(true, CursorContext.NULL_CONTEXT);
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public LongSet validate(LongSet skippedEntityIds, Collector collector) {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        try {
            for (Map.Entry<IndexDescriptor, IndexPopulator> population : this.indexPopulators.entrySet()) {
                IndexDescriptor descriptor = population.getKey();
                RecordingIndexEntryConflictHandler conflictHandler = new RecordingIndexEntryConflictHandler(collector, this.violatingEntities, descriptor, this.tokenNameLookup, this.entityIdFromIndexIdConverter);
                if (!descriptor.isUnique()) continue;
                IndexAccessor copiedIncrementIndex = this.indexProviderMap.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
                try {
                    IndexAccessor builtIncrementIndex = this.tempIndexes.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
                    try {
                        copiedIncrementIndex.validate(builtIncrementIndex, true, (IndexEntryConflictHandler)conflictHandler, arg_0 -> ((LongSet)skippedEntityIds).contains(arg_0), this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler());
                    }
                    finally {
                        if (builtIncrementIndex == null) continue;
                        builtIncrementIndex.close();
                    }
                }
                finally {
                    if (copiedIncrementIndex == null) continue;
                    copiedIncrementIndex.close();
                }
            }
            LongPredicate filter = skippedEntityIds.isEmpty() && this.violatingEntities.isEmpty() ? null : indexEntityId -> !skippedEntityIds.contains(indexEntityId) && !this.violatingEntities.contains(this.entityIdFromIndexIdConverter.applyAsLong(indexEntityId));
            for (IndexDescriptor descriptor : this.indexPopulators.keySet()) {
                if (!descriptor.isUnique() && filter == null && this.incrementalIndexing) {
                    IncrementalBatchImportUtil.moveIndex(this.fileSystem, this.tempIndexes, this.indexProviderMap, descriptor);
                    continue;
                }
                IndexAccessor copiedIncrementIndex = this.indexProviderMap.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
                try {
                    IndexAccessor builtIncrementIndex = this.tempIndexes.lookup(descriptor.getIndexProvider()).getOnlineAccessor(descriptor, indexSamplingConfig, this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, this.openOptions, this.indexingBehaviour);
                    try {
                        copiedIncrementIndex.insertFrom(builtIncrementIndex, null, false, IndexEntryConflictHandler.THROW, filter, this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler(), ProgressListener.NONE);
                        copiedIncrementIndex.force(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
                    }
                    finally {
                        if (builtIncrementIndex == null) continue;
                        builtIncrementIndex.close();
                    }
                }
                finally {
                    if (copiedIncrementIndex == null) continue;
                    copiedIncrementIndex.close();
                }
            }
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.violatingEntities;
    }

    @Override
    public void close() throws IOException {
        this.bufferFactory.close();
    }

    public LongSet affectedIndexes() {
        MutableLongSet ids = LongSets.mutable.empty();
        this.indexPopulators.keySet().stream().map(IndexDescriptor::getId).forEach(arg_0 -> ((MutableLongSet)ids).add(arg_0));
        return ids;
    }

    private class OtherAffectedSchemaMonitor
    implements SchemaMonitor {
        private final MutableIntList entityTokens = IntLists.mutable.empty();
        private final MutableIntObjectMap<Value> properties = IntObjectMaps.mutable.empty();

        private OtherAffectedSchemaMonitor() {
        }

        @Override
        public void property(int propertyKeyId, Object value) {
            if (value instanceof Value) {
                Value propValue = (Value)value;
                this.properties.put(propertyKeyId, (Object)propValue);
            } else {
                this.properties.put(propertyKeyId, (Object)Values.of((Object)value));
            }
        }

        @Override
        public void entityToken(int entityTokenId) {
            this.entityTokens.add(entityTokenId);
        }

        @Override
        public void entityTokens(int[] entityTokenIds) {
            this.entityTokens.addAll(entityTokenIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean endOfEntity(long entityId, SchemaMonitor.ViolationVisitor violationVisitor) {
            try {
                this.entityTokens.sortThis();
                boolean propertyExistenceOk = this.checkPropertyExistenceConstraints(entityId, violationVisitor);
                if (propertyExistenceOk) {
                    this.generateIndexUpdatesForAffectedIndexes(entityId);
                }
                boolean bl = propertyExistenceOk;
                return bl;
            }
            finally {
                this.entityTokens.clear();
                this.properties.clear();
            }
        }

        private void generateIndexUpdatesForAffectedIndexes(long entityId) {
            int[] propertyKeyTokens = this.properties.keySet().toSortedArray();
            Set indexes = OtherAffectedSchemaMonitors.this.schemaCache.getValueIndexesRelatedTo(this.entityTokens.toArray(), ArrayUtils.EMPTY_INT_ARRAY, propertyKeyTokens, true, OtherAffectedSchemaMonitors.this.entityType);
            for (IndexDescriptor index : indexes) {
                IndexPopulator populator = this.getIndexPopulator(index);
                IndexEntryUpdate<IndexDescriptor> indexUpdate = this.constructIndexUpdate(entityId, index);
                try {
                    populator.add(List.of(indexUpdate), CursorContext.NULL_CONTEXT);
                    populator.includeSample(indexUpdate);
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private IndexEntryUpdate<IndexDescriptor> constructIndexUpdate(long entityId, IndexDescriptor index) {
            int[] propertyIds = index.schema().getPropertyIds();
            Value[] values = new Value[propertyIds.length];
            for (int i = 0; i < propertyIds.length; ++i) {
                values[i] = (Value)this.properties.get(propertyIds[i]);
            }
            return IndexEntryUpdate.add((long)OtherAffectedSchemaMonitors.this.indexedEntityIdConverter.applyAsLong(entityId), (SchemaDescriptorSupplier)index, (Value[])values);
        }

        private IndexPopulator getIndexPopulator(IndexDescriptor index) {
            IndexPopulator populator = OtherAffectedSchemaMonitors.this.indexPopulators.get(index);
            if (populator == null) {
                OtherAffectedSchemaMonitors.this.populatorConstructionLock.lock();
                try {
                    populator = OtherAffectedSchemaMonitors.this.indexPopulators.get(index);
                    if (populator == null) {
                        populator = this.constructIndexPopulator(index);
                        OtherAffectedSchemaMonitors.this.indexPopulators.put(index, populator);
                    }
                }
                finally {
                    OtherAffectedSchemaMonitors.this.populatorConstructionLock.unlock();
                }
            }
            return populator;
        }

        private IndexPopulator constructIndexPopulator(IndexDescriptor index) {
            IndexProvider indexProvider = OtherAffectedSchemaMonitors.this.tempIndexes.lookup(index.getIndexProvider());
            IndexPopulator populator = indexProvider.getPopulator(index, new IndexSamplingConfig(Config.defaults()), OtherAffectedSchemaMonitors.this.bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, OtherAffectedSchemaMonitors.this.tokenNameLookup, ElementIdMapper.PLACEHOLDER, OtherAffectedSchemaMonitors.this.openOptions, OtherAffectedSchemaMonitors.this.indexingBehaviour);
            try {
                populator.create();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return populator;
        }

        private boolean checkPropertyExistenceConstraints(long entityId, SchemaMonitor.ViolationVisitor violationVisitor) {
            if (OtherAffectedSchemaMonitors.this.propertyExistenceConstraints != null) {
                MutableIntIterator entityTokensIterator = this.entityTokens.intIterator();
                while (entityTokensIterator.hasNext()) {
                    List existenceConstraints = (List)OtherAffectedSchemaMonitors.this.propertyExistenceConstraints.get(entityTokensIterator.next());
                    if (existenceConstraints == null) continue;
                    for (int[] mandatoryProperties : existenceConstraints) {
                        if (this.properties.keySet().containsAll(mandatoryProperties)) continue;
                        violationVisitor.accept(entityId, (IntList)this.entityTokens, (IntObjectMap<Value>)this.properties, "a property existence constraint");
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private record RecordingIndexEntryConflictHandler(Collector badCollector, MutableLongSet violatingEntities, IndexDescriptor descriptor, TokenNameLookup tokenNameLookup, LongToLongFunction entityIdFromIndexIdConverter) implements IndexEntryConflictHandler
    {
        public IndexEntryConflictHandler.IndexEntryConflictAction indexEntryConflict(long firstEntityId, long otherEntityId, Value[] values) {
            long realId = this.entityIdFromIndexIdConverter.applyAsLong(otherEntityId);
            this.violatingEntities.add(realId);
            this.badCollector.collectEntityViolatingConstraint(null, realId, this.asPropertyMap(this.descriptor, values), this.descriptor.userDescription(this.tokenNameLookup), this.descriptor.schema().entityType());
            return IndexEntryConflictHandler.IndexEntryConflictAction.DELETE;
        }

        private Map<String, Object> asPropertyMap(IndexDescriptor descriptor, Value[] values) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            int[] propertyIds = descriptor.schema().getPropertyIds();
            for (int i = 0; i < propertyIds.length; ++i) {
                properties.put(this.tokenNameLookup.propertyKeyGetName(propertyIds[i]), values[i].asObjectCopy());
            }
            return properties;
        }
    }
}

