/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.UnexpectedEndOfInputException;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.IdValueBuilder;
import org.neo4j.internal.batchimport.input.csv.Type;

public class CsvInputParser
implements Closeable {
    private final CharSeeker seeker;
    private final Mark mark = new Mark();
    private final IdType idType;
    private final Header header;
    private final int delimiter;
    private final Collector badCollector;
    private final Extractor<String> stringExtractor;
    private final IdValueBuilder idValueBuilder = new IdValueBuilder();
    private long lineNumber;

    public CsvInputParser(CharSeeker seeker, int delimiter, IdType idType, Header header, Collector badCollector, Extractors extractors) {
        this.seeker = seeker;
        this.delimiter = delimiter;
        this.idType = idType;
        this.header = header;
        this.badCollector = badCollector;
        this.stringExtractor = extractors.string();
    }

    boolean next(InputEntityVisitor visitor) throws IOException {
        ++this.lineNumber;
        int i = 0;
        Header.Entry entry = null;
        Header.Entry[] entries = this.header.entries();
        try {
            boolean doContinue = true;
            this.idValueBuilder.clear();
            for (i = 0; i < entries.length && doContinue; ++i) {
                Object value;
                Iterator<IdValueBuilder.Part> extractor;
                entry = entries[i];
                if (!this.seeker.seek(this.mark, this.delimiter)) {
                    if (i > 0) {
                        throw new UnexpectedEndOfInputException("Near " + this.mark);
                    }
                    return false;
                }
                if (entry.type() == Type.IGNORE || (extractor = entry.extractor()).isEmpty(value = this.seeker.tryExtract(this.mark, extractor, entry.optionalParameter()))) continue;
                doContinue = switch (entry.type()) {
                    case Type.ID -> {
                        switch (this.idType) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case STRING: 
                            case INTEGER: {
                                this.idValueBuilder.part(value, entry);
                                yield true;
                            }
                            case ACTUAL: 
                        }
                        yield visitor.id(((Long)value).longValue());
                    }
                    case Type.START_ID -> {
                        switch (this.idType) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case STRING: 
                            case INTEGER: {
                                yield visitor.startId(value, entry.group());
                            }
                            case ACTUAL: 
                        }
                        yield visitor.startId(((Long)value).longValue());
                    }
                    case Type.END_ID -> {
                        switch (this.idType) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case STRING: 
                            case INTEGER: {
                                yield visitor.endId(value, entry.group());
                            }
                            case ACTUAL: 
                        }
                        yield visitor.endId(((Long)value).longValue());
                    }
                    case Type.TYPE -> visitor.type((String)value);
                    case Type.PROPERTY -> {
                        if (!CsvInputParser.isEmptyArray(value) && visitor.property(entry.name(), value)) {
                            yield true;
                        }
                        yield false;
                    }
                    case Type.LABEL -> {
                        if (value.getClass().isArray()) {
                            yield visitor.labels((String[])value);
                        }
                        yield visitor.labels(new String[]{(String)value});
                    }
                    default -> throw new IllegalArgumentException(entry.type().toString());
                };
                if (this.mark.isEndOfLine()) break;
            }
            if (!this.idValueBuilder.isEmpty() && (doContinue = visitor.id(this.idValueBuilder.value(), this.idValueBuilder.group()))) {
                for (IdValueBuilder.Part idPropertyValue : this.idValueBuilder.idPropertyValues()) {
                    doContinue = visitor.property(idPropertyValue.name(), idPropertyValue.value());
                }
            }
            while (!this.mark.isEndOfLine()) {
                this.seeker.seek(this.mark, this.delimiter);
                if (!doContinue) continue;
                String value = (String)this.seeker.tryExtract(this.mark, this.stringExtractor, entry.optionalParameter());
                this.badCollector.collectExtraColumns(this.seeker.sourceDescription(), this.lineNumber, value);
            }
            visitor.endOfEntity();
            return true;
        }
        catch (RuntimeException e) {
            String stringValue = null;
            try {
                Extractors extractors = new Extractors('?');
                stringValue = (String)this.seeker.tryExtract(this.mark, extractors.string(), entry.optionalParameter());
            }
            catch (Exception extractors) {
                // empty catch block
            }
            String message = String.format("ERROR in input%n  data source: %s%n  in field: %s%n  for header: %s%n  raw field value: %s%n  original error: %s", this.seeker, entry + ":" + (i + 1), this.header, stringValue != null ? stringValue : "??", e.getMessage());
            throw new InputException(message, e);
        }
    }

    private static boolean isEmptyArray(Object value) {
        return value.getClass().isArray() && Array.getLength(value) == 0;
    }

    @Override
    public void close() throws IOException {
        this.seeker.close();
    }
}

