/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.OffHeapNumberArray;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.memory.MemoryTracker;

public class OffHeapByteArray
extends OffHeapNumberArray<ByteArray>
implements ByteArray {
    private final byte[] defaultValue;

    protected OffHeapByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
        super(length, defaultValue.length, base, memoryTracker);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public void swap(long fromIndex, long toIndex) {
        int chunkSize;
        long fromAddress = this.address(fromIndex, 0);
        long toAddress = this.address(toIndex, 0);
        for (int bytesLeft = this.itemSize; bytesLeft > 0; bytesLeft -= chunkSize) {
            if (bytesLeft >= 8) {
                chunkSize = 8;
                long intermediary = OffHeapByteArray.getLong(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                OffHeapByteArray.putLong(toAddress, intermediary);
            } else if (bytesLeft >= 4) {
                chunkSize = 4;
                int intermediary = OffHeapByteArray.getInt(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                OffHeapByteArray.putInt(toAddress, intermediary);
            } else if (bytesLeft >= 2) {
                chunkSize = 2;
                short intermediary = OffHeapByteArray.getShort(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                OffHeapByteArray.putShort(toAddress, intermediary);
            } else {
                chunkSize = 1;
                byte intermediary = OffHeapByteArray.getByte(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                OffHeapByteArray.putByte(toAddress, intermediary);
            }
            fromAddress += (long)chunkSize;
            toAddress += (long)chunkSize;
        }
    }

    @Override
    public void clear() {
        if (OffHeapByteArray.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory((long)this.address, (long)(this.length * (long)this.itemSize), (byte)this.defaultValue[0]);
        } else {
            long intermediary = UnsafeUtil.allocateMemory((long)this.itemSize, (MemoryTracker)this.memoryTracker);
            for (int i = 0; i < this.defaultValue.length; ++i) {
                UnsafeUtil.putByte((long)(intermediary + (long)i), (byte)this.defaultValue[i]);
            }
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.copyMemory((long)intermediary, (long)adr, (long)this.itemSize);
                ++i;
                adr += (long)this.itemSize;
            }
            UnsafeUtil.free((long)intermediary, (long)this.itemSize, (MemoryTracker)this.memoryTracker);
        }
    }

    private static boolean isByteUniform(byte[] bytes) {
        byte reference = bytes[0];
        for (int i = 1; i < bytes.length; ++i) {
            if (reference == bytes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void get(long index, byte[] into) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            into[i] = UnsafeUtil.getByte((long)address);
            ++i;
            ++address;
        }
    }

    @Override
    public byte getByte(long index, int offset) {
        return UnsafeUtil.getByte((long)this.address(index, offset));
    }

    private static byte getByte(long p) {
        return UnsafeUtil.getByte((long)p);
    }

    @Override
    public short getShort(long index, int offset) {
        return OffHeapByteArray.getShort(this.address(index, offset));
    }

    private static short getShort(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            return UnsafeUtil.getShort((long)p);
        }
        return UnsafeUtil.getShortByteWiseLittleEndian((long)p);
    }

    @Override
    public int getInt(long index, int offset) {
        return OffHeapByteArray.getInt(this.address(index, offset));
    }

    private static int getInt(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            return UnsafeUtil.getInt((long)p);
        }
        return UnsafeUtil.getIntByteWiseLittleEndian((long)p);
    }

    @Override
    public long get5ByteLong(long index, int offset) {
        long high1b;
        long address = this.address(index, offset);
        long low4b = (long)OffHeapByteArray.getInt(address) & 0xFFFFFFFFL;
        long result = low4b | (high1b = (long)(UnsafeUtil.getByte((long)(address + 4L)) & 0xFF)) << 32;
        return result == 0xFFFFFFFFFFL ? -1L : result;
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        long high2b;
        long address = this.address(index, offset);
        long low4b = (long)OffHeapByteArray.getInt(address) & 0xFFFFFFFFL;
        long result = low4b | (high2b = (long)(OffHeapByteArray.getShort(address + 4L) & 0xFFFF)) << 32;
        return result == 0xFFFFFFFFFFFFL ? -1L : result;
    }

    @Override
    public long getLong(long index, int offset) {
        long p = this.address(index, offset);
        return OffHeapByteArray.getLong(p);
    }

    private static long getLong(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            return UnsafeUtil.getLong((long)p);
        }
        return UnsafeUtil.getLongByteWiseLittleEndian((long)p);
    }

    @Override
    public void set(long index, byte[] value) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            UnsafeUtil.putByte((long)address, (byte)value[i]);
            ++i;
            ++address;
        }
    }

    @Override
    public void setByte(long index, int offset, byte value) {
        UnsafeUtil.putByte((long)this.address(index, offset), (byte)value);
    }

    private static void putByte(long p, byte value) {
        UnsafeUtil.putByte((long)p, (byte)value);
    }

    @Override
    public void setShort(long index, int offset, short value) {
        OffHeapByteArray.putShort(this.address(index, offset), value);
    }

    private static void putShort(long p, short value) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putShort((long)p, (short)value);
        } else {
            UnsafeUtil.putShortByteWiseLittleEndian((long)p, (short)value);
        }
    }

    @Override
    public void setInt(long index, int offset, int value) {
        OffHeapByteArray.putInt(this.address(index, offset), value);
    }

    private static void putInt(long p, int value) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putInt((long)p, (int)value);
        } else {
            UnsafeUtil.putIntByteWiseLittleEndian((long)p, (int)value);
        }
    }

    @Override
    public void set5ByteLong(long index, int offset, long value) {
        long address = this.address(index, offset);
        OffHeapByteArray.putInt(address, (int)value);
        UnsafeUtil.putByte((long)(address + 4L), (byte)((byte)(value >>> 32)));
    }

    @Override
    public void set6ByteLong(long index, int offset, long value) {
        long address = this.address(index, offset);
        OffHeapByteArray.putInt(address, (int)value);
        OffHeapByteArray.putShort(address + 4L, (short)(value >>> 32));
    }

    @Override
    public void setLong(long index, int offset, long value) {
        long p = this.address(index, offset);
        OffHeapByteArray.putLong(p, value);
    }

    private static void putLong(long p, long value) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putLong((long)p, (long)value);
        } else {
            UnsafeUtil.putLongByteWiseLittleEndian((long)p, (long)value);
        }
    }

    @Override
    public int get3ByteInt(long index, int offset) {
        int highByte;
        long address = this.address(index, offset);
        int lowWord = UnsafeUtil.getShort((long)address) & 0xFFFF;
        int result = lowWord | (highByte = UnsafeUtil.getByte((long)(address + 2L)) & 0xFF) << 16;
        return result == 0xFFFFFF ? -1 : result;
    }

    @Override
    public void set3ByteInt(long index, int offset, int value) {
        long address = this.address(index, offset);
        UnsafeUtil.putShort((long)address, (short)((short)value));
        UnsafeUtil.putByte((long)(address + 2L), (byte)((byte)(value >>> 16)));
    }

    private long address(long index, int offset) {
        this.checkBounds(index);
        return this.address + this.rebase(index) * (long)this.itemSize + (long)offset;
    }

    private void checkBounds(long index) {
        long rebased = this.rebase(index);
        if (rebased < 0L || rebased >= this.length) {
            throw new IndexOutOfBoundsException("Wanted to access " + rebased + " but range is " + this.base + "-" + this.length);
        }
    }
}

