/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.util.Arrays;
import org.neo4j.util.BitUtils;

public class LongBitsManipulator {
    private final Slot[] slots;

    public LongBitsManipulator(int ... slotsAndTheirBitCounts) {
        this.slots = LongBitsManipulator.intoSlots(slotsAndTheirBitCounts);
    }

    private static Slot[] intoSlots(int[] slotsAndTheirSizes) {
        Slot[] slots = new Slot[slotsAndTheirSizes.length];
        int bitCursor = 0;
        for (int i = 0; i < slotsAndTheirSizes.length; ++i) {
            int bits = slotsAndTheirSizes[i];
            long mask = (1L << bits) - 1L;
            slots[i] = new Slot(bits, mask <<= bitCursor, bitCursor);
            bitCursor += bits;
        }
        return slots;
    }

    public long set(long field, int slotIndex, long value) {
        return this.slot(slotIndex).set(field, value);
    }

    public long get(long field, int slotIndex) {
        return this.slot(slotIndex).get(field);
    }

    public long clear(long field, int slotIndex, boolean trueForAllOnes) {
        return this.slot(slotIndex).clear(field, trueForAllOnes);
    }

    public long template(boolean ... trueForOnes) {
        if (trueForOnes.length != this.slots.length) {
            throw new IllegalArgumentException("Invalid boolean arguments, expected " + this.slots.length);
        }
        long field = 0L;
        for (int i = 0; i < trueForOnes.length; ++i) {
            field = this.slots[i].clear(field, trueForOnes[i]);
        }
        return field;
    }

    private Slot slot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.slots.length) {
            throw new IllegalArgumentException("Invalid slot " + slotIndex + ", I've got " + this);
        }
        return this.slots[slotIndex];
    }

    public String toString() {
        return Arrays.toString(this.slots);
    }

    private static class Slot {
        private final long mask;
        private final long maxValue;
        private final int bitOffset;

        Slot(int bits, long mask, int bitOffset) {
            this.mask = mask;
            this.bitOffset = bitOffset;
            this.maxValue = (1L << bits) - 1L;
        }

        public long get(long field) {
            long raw = field & this.mask;
            return raw == this.mask ? -1L : raw >>> this.bitOffset;
        }

        public long set(long field, long value) {
            if (value < -1L || value > this.maxValue) {
                throw new IllegalStateException("Invalid value " + value + ", max is " + this.maxValue);
            }
            long otherBits = field & (this.mask ^ 0xFFFFFFFFFFFFFFFFL);
            return value << this.bitOffset & this.mask | otherBits;
        }

        public long clear(long field, boolean trueForAllOnes) {
            long otherBits = field & (this.mask ^ 0xFFFFFFFFFFFFFFFFL);
            return trueForAllOnes ? otherBits | this.mask : otherBits;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + BitUtils.numbersToBitString((long[])new long[]{this.maxValue << this.bitOffset}) + "]";
        }
    }
}

