/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.neo4j.internal.batchimport.cache.idmapping.string.Encoder;

public class StringEncoder
implements Encoder {
    private static final long UPPER_INT_MASK = 0xFFFFFFFFL;
    private static final int FOURTH_BYTE = 255;
    private static final int ENCODING_THRESHOLD = 7;

    @Override
    public long encode(Object any) {
        String s = (String)any;
        int inputLength = s.length();
        byte[] bytes = new byte[inputLength];
        for (int i = 0; i < inputLength; ++i) {
            bytes[i] = (byte)(s.charAt(i) % 127);
        }
        if (inputLength <= 7) {
            return StringEncoder.simplestCode(bytes, inputLength);
        }
        int low = StringEncoder.getCode(bytes, inputLength, 1);
        int high = StringEncoder.getCode(bytes, inputLength, inputLength - 1);
        int carryOver = StringEncoder.lengthEncoder(inputLength) << 1;
        int temp = low & 0xFF;
        low = low >>> 8 | carryOver << 24;
        carryOver = temp;
        high = high >>> 8 | carryOver << 24;
        return (long)low << 32 | (long)high & 0xFFFFFFFFL;
    }

    private static int lengthEncoder(int length) {
        if (length < 32) {
            return length;
        }
        if (length <= 96) {
            return length >> 1;
        }
        if (length <= 324) {
            return length >> 2;
        }
        if (length <= 580) {
            return length >> 3;
        }
        if (length <= 836) {
            return length >> 4;
        }
        return 127;
    }

    private static long simplestCode(byte[] bytes, int inputLength) {
        int i;
        int low = Math.max(inputLength, 1) << 25;
        int high = 0;
        for (i = 0; i < 3 && i < inputLength; ++i) {
            low |= bytes[i] << (2 - i) * 8;
        }
        for (i = 3; i < 7 && i < inputLength; ++i) {
            high |= bytes[i] << (6 - i) * 8;
        }
        return (long)low << 32 | (long)high & 0xFFFFFFFFL;
    }

    private static int getCode(byte[] bytes, int inputLength, int order) {
        long code = 0L;
        int size = inputLength;
        for (int i = 0; i < size; ++i) {
            long val = bytes[i * order % size];
            for (int k = 1; k <= i; ++k) {
                long prev = val;
                val = (val << 4) + prev;
            }
            code += val;
        }
        return (int)code;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

